<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
/**
* WebService XML-RPC d'excution de requtes SQL
*
*
* @package MyRemoteSql
* @author MyRemoteSql
*/
//
// Inclusion des deux bibliothques de fonctions xmlrpc
include("Lib/xmlrpc.inc");
include("Lib/xmlrpcs.inc");
//
include_once("mrsconf_inc.php");
$dirLang = DIRLANG;
$mrsLang = MRSLANG;
include_once("$dirLang/$mrsLang");
include_once("Lib/myremotesql_class.php");
include_once("Lib/sql_inc.php");
include_once("Lib/general_inc.php");
include_once("Lib/appgen_inc.php");
include_once("Lib/convertion_class.php");

//xmlrpc_debugmsg($mrsLang);

$wsExecuteSql_sig = array(array($xmlrpcArray,$xmlrpcString,$xmlrpcStruct,$xmlrpcString,$xmlrpcString));
$wsExecuteSql_doc = "Execute une requete SQL sur N serveurs";

function wsExecuteSql($pParam)
{
    global $xmlrpcerruser;
    global $txtLang;
       
	// Rcupration des paramtres de la fonction
	$pTxtSql_o = $pParam->getParam(0); 
	$pTxtSql = $pTxtSql_o->scalarval();
	
  	$pServeurs_o = $pParam->getParam(1); 
   	$pServeurs = xmlrpc_decode($pServeurs_o);
   	
	$pTypeSortie_o = $pParam->getParam(2); 
   	$pTypeSortie = $pTypeSortie_o->scalarval();;

   	$pTxtSql = trim($pTxtSql);

   	$pPreSortie_o = $pParam->getParam(3); 
   	$pPreSortie = $pPreSortie_o->scalarval();;
	
	// Vrification de la requte : mots interdits ...
 	$bRet = verifClauseSql($pTxtSql);
	if (trim($bRet) != "")
	{
		return new xmlrpcresp(0, $xmlrpcerruser + 1, $bRet);
	}
	
	$arrayEntete = array();
	$arrayResultat = array();
	$arrayResultatTot = array();
	$arrayResultatConvert = array();
	
	// Suppression des antislach
	$txtsql = stripslashes($txtsql);
	
	// Dfinition de l'entete
	$arrayEntete[] = dimLgCode("H") . $txtLang['debuttraitement'] . " " . date(LNGDATEHMS);
	$arrayEntete[] = dimLgCode("H") . $txtLang['reqsqlest'];
	$arrayEntete[] = dimLgCode("H") . $pTxtSql;

	// Cration d'une instance de l'objet
	$remoteSql = new myRemoteSql();
	
	// Dfinition des attributs
	$remoteSql->typeDatabase = "mysql";
	$remoteSql->texteSql = $pTxtSql;
		
	// Excution du moteur de requtes 
	$arrayResultat = $remoteSql->executeSql($pServeurs,$pTxtSql,$pPreSortie);
	
	// Merge Entete + Data
	$arrayResultatTot = array_merge($arrayEntete,$arrayResultat);
	
	// Cration d'une instance de l'objet de Convertion du rsultat
	$convertion = new convertion();
	
	// Dfinition des attributs
	$convertion->typeSortie = $pTypeSortie;
	$convertion->preSortie = $pPreSortie;
	
	$arrayResultatConvert = $convertion->convertResult($arrayResultatTot);
		
	// Renvoi du rsultat
	$z=xmlrpc_encode($arrayResultatConvert);
	return new xmlrpcresp($z); 
}

$wsGetVersion_sig = array(array($xmlrpcString));
$wsGetVersion_doc = "Renvoi le No de version de l'application";
/**
* Fonction wsGetVersion : Renvoi le No de Version
*
* Renvoi le No de Version
*
*
* @return String
*/
function wsGetVersion($xmlrpcString)
{
	$numVersion = MYREMOTESQL_VERSION;
	return new xmlrpcresp(new xmlrpcval($numVersion));
}


//Dfinition des fonctions du serveur XML-RPC

$servFct = new xmlrpc_server( array(
"mrs.wsExecuteSql" =>
    array("function" => "wsExecuteSql",
    "signature" => $wsExecuteSql_sig,
    "docstring" => $wsExecuteSql_doc),
"mrs.wsGetVersion" =>
	array("function" => "wsGetVersion",
    "signature" => $wsGetVersion_sig,
    "docstring" => $wsGetVersion_doc)
));
?>