<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
/**
* Excution de la requte sur les serveurs 
*
* Excution de(s) requte(s) SQL sur les N serveur(s)
* Affichage du rsultats
*
* @package MyRemoteSql
* @author MyRemoteSql
*/
include_once("Lib/entete_inc.php");
include_once("Lib/sql_inc.php");
include_once("Lib/myremotesql_class.php");
include_once("Lib/convertion_class.php");

/**
* Fonction afficheInfos
*
* Fonction D'affichage de messages : infos, erreurs ...
*
* @param string Message  afficher
*
*/
function afficheInfos($pInfos)
{
	print("<div id=\"divresultatsdata\">\n");
	print("$pInfos\n");
	print("</div>\n");
}

//
print(afficheEntete());
print(afficheTitre("MyRemoteSQL - ".$txtLang['resultats']));

//******  Dbut de programme

// La liste des serveurs est tablie ?
if (isset($ListServeurs))
{
	// Rcup des proprits des serveurs
	$listServeursaTraiter = getProprieteServeurs($ListServeurs);
		
	$typeAction = strtoupper(trim($hidaction));

	switch ($typeAction)
	{
			case "COMP":	// Comparaison de base
				if ( ( ! isset($ListServeursref)) or (trim($ListServeursref[0]) == ""))
				{
					afficheInfos($txtLang['serveurrefnondefini']);
					die($txtLang['erreur']);
				}
				$listServeurRefaTraiter = getProprieteServeurs($ListServeursref);
				$preSortie = "S-SQL";
				break;
				
			case "SQL":		// Excution de requtes SQL
				// Suppression des antislach + espaces
				$txtsql = stripslashes(trim($txtsql));
				
				// Vrif de la clause SQL (mots interdits ...) : arret si PB
				$bRet = verifClauseSql($txtsql);
				if (trim($bRet) != "")
				{
					// Affichage cran de sortie
					afficheInfos($bRet);
					$ret = logMessage(__FILE__." Ligne : ". __LINE__." $bRet","","2");
					die($txtLang['erreur']);
				}
				break;
				
			default:
				afficheInfos($txtLang['errparametreinvalide']." : $typeAction");
				die($txtLang['erreur']);
	}
	
	// Sortie Fichier ?
	if (trim($txtfichiersortie) != "")
	{
		$sortieFichier = true;
	}
	else
	{
		$sortieFichier = false;
	}

	// Fichier de sortie en Append ?
	if (isset($chkfichierajout))
	{
		$fichierAjout = "a";
	}
	else
	{
		$fichierAjout = "w";
	}
	
	// Cration du fichier si inexistant
	if ($sortieFichier)
	{
		$bRet = ecritFichier($txtfichiersortie," ",$fichierAjout);
		if ( ! $bRet)
		{
			// Affichage cran de sortie
			afficheInfos($txtLang['errfichierouv'] . $txtfichiersortie);
			$ret = logMessage(__FILE__ . " Ligne : " .  __LINE__ . $txtLang['errfichierouv'] . $txtfichiersortie,"","2");
			die($txtLang['errfichierouv'].$txtfichiersortie);	
		}
	}
	
	$arrayEntete = array();
	$arrayResultat = array();
	$arrayResultatTot = array();
	$arrayResultatConvert = array();
	
	// Dfinition de l'entete
	$arrayEntete[] = dimLgCode("H") . $txtLang['debuttraitement']." ". date(LNGDATEHMS);
	$arrayEntete[]= dimLgCode("PERSO") . getCommentairesPerso();
	if ($typeAction == "SQL")
	{
		$arrayEntete[] = dimLgCode("H") . $txtLang['reqsqlest'];
		$arrayEntete[] = dimLgCode("H") . $txtsql;
	}
	
	// Cration d'une instance de l'objet
	$remoteSql = new myRemoteSql();
	
	// Dfinition des attributs
	$remoteSql->typeDatabase = "mysql";
	$remoteSql->texteSql = $txtsql;
		
	if ($typeAction == "SQL")
	{
		// Excution du moteur de requtes SQL
		$arrayResultat = $remoteSql->executeSql($listServeursaTraiter,$txtsql,$preSortie);
	}
	if ($typeAction == "COMP")
	{
		// Excution du moteur de comparaison de bases
		$arrayResultat = $remoteSql->compareBaseSql($listServeursaTraiter,$listServeurRefaTraiter[0]);
	}
	// Merge Entete + Data
	$arrayResultatTot = array_merge($arrayEntete, $arrayResultat);
		
	// Cration d'une instance de l'objet de Convertion du rsultat
	$convertion = new convertion();
	
	// Dfinition des attributs
	$convertion->skinHtml = $HTTP_COOKIE_VARS["myremotesqlskinhtml"];
	$convertion->typeSortie = $typeSortie;
	$convertion->preSortie = $preSortie;
	
	if ($sortieFichier)
	{
		//$remoteSql->typeSortie = $typeSortie;
		$convertion->typeSortie = $typeSortie;
		
		// Conversion du rsultat
		$arrayResultatConvert = $convertion->convertResult($arrayResultatTot);
		
		// Sortie fichier
		$bRet = $convertion->resultToFile($txtfichiersortie,$arrayResultatConvert,$fichierAjout);
	}
	// Conversion du rsultat
	$convertion->typeSortie = "HTML";
	$arrayResultatConvert = $convertion->convertResult($arrayResultatTot);

	// Affichage cran de sortie
	print("<div id=\"divresultatsdata\">\n");
	print("<pre>\n");
	$bRet = $convertion->resultToPrint($arrayResultatConvert);
	print("</pre>\n");
	print("</div>\n");
			
	// Fin si liste serveur
}
else
{
	// Affichage cran de sortie
	afficheInfos($txtLang['errserveurnondefini']);
}

?>
<div id="divresultats">
		<span id="spanresultats">
		<?php print($txtLang['resultats']);?>		
		</span>
		<br />
		<br />
		<?php
			print($txtLang['typesortie'] . " : $typeSortie <br />");
			print($txtLang['fichiersortie'] . " : <a href=\"$txtfichiersortie\">$txtfichiersortie</a><br />");
		?>
</div>
</body>
</html>