<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
/**
* Explorateur des serveurs
*
*
* @package MyRemoteSql
* @author MyRemoteSql
*/
include_once("Lib/entete_inc.php");
include_once("Lib/sql_inc.php");
include_once("Lib/myremotesql_class.php");
include_once("Lib/convertion_class.php");

print(afficheEntete());
print(afficheTitre("MyRemoteSQL - ".$txtLang['explorateur']));
print("<script type=\"text/javascript\" src=\"Trv/ua.js\"></script>\n");
print("<script type=\"text/javascript\" src=\"Trv/ftiens4.js\"></script>\n");

$noVersion = MYREMOTESQL_VERSION;

$arrayResultat = array();
$arrayResultatConvert = array();
$arrayHtml = array();
$proprieteServeur = array();

// Recup des serveurs
$arrayServeur = chargeArrayFromFic(FILESERVEUR);

// Cration du script Js pour TreeView
$htmlText = "<script type=\"text/javascript\">\n";
$htmlText .= "USETEXTLINKS = 1;\n";
$htmlText .= "STARTALLOPEN = 0;\n";
$htmlText .= "USEFRAMES = 0;\n";
$htmlText .= "USEICONS = 1;\n";
$htmlText .= "WRAPTEXT = 1;\n";
$htmlText .= "PRESERVESTATE = 1;\n";
$htmlText .= "ICONPATH='Trv/';\n";

$htmlText .= "foldersTree = gFld('MyRemoteSql $noVersion', 'explorer.php');\n";

// Parcourt des serveurs
for ($i = 0; $i < count($arrayServeur); $i++)
{
	$connect = true;
	
	$proprieteServeur = explode(";",$arrayServeur[$i]);
	// Entete serveur
	$htmlText  .= "aux$i = insFld(foldersTree, gFld('$proprieteServeur[1]', 'javascript:undefined'));\n";
	
	// Affichage IP
	$htmlText  .= "insDoc(aux$i, gLnk('S', '@Ip : $proprieteServeur[2]', 'javascript:undefined'));\n";

	// Connexion serveur
	$connexion = connectServeur($proprieteServeur[2],$proprieteServeur[3],$proprieteServeur[5],$proprieteServeur[6]);
	if ($connexion == false)
	{
		$connect = false;
	}	
	
	// Connexion base
	$ret = connectBase($connexion,$proprieteServeur[4]);
	if ($ret == false)
	{
		$connect = false;
	}
	
	// Liste des Tables de la base
	$htmlText  .= "aux$i"."1 = insFld(aux$i, gFld('$proprieteServeur[4]', 'javascript:undefined'));\n";
	if ($connect)
	{
	 	$arrayTable = getDbTables($connexion,$proprieteServeur[4]);
	 	if ($arrayTable == false)
		{
			$htmlText  .= "insDoc(aux$i"."1, gLnk('S', 'Inconnu', 'javascript:undefined'));\n";
		}
		else
		{
			// affichage de la liste des tables
			for($j = 0 ; $j < count($arrayTable) ; $j++)
			{
				$htmlText  .= "insDoc(aux$i"."1, gLnk('S', '$arrayTable[$j]', 'explorer.php?serveur=$proprieteServeur[0]&table=$arrayTable[$j]&action=tbl'));\n";
			}
		}	
		// dconnexion de la base
		mysql_close($connexion);
	}
	    
	// Action Liste processes
	$htmlText  .= "insDoc(aux$i, gLnk('S', 'Liste des Process', 'explorer.php?serveur=$proprieteServeur[0]&action=prs'));\n";
}
$htmlText  .= "</script>\n";

// Ecriture du Js
print($htmlText);
?>
<table border="0"><tr><td><a href="http://www.treemenu.net/" target="_blank">Mrs</a></td></tr></table>
<div class="divtreeview">
<span id="spanserveurs">
<?php print($txtLang['serveurs']);?>
</span>
<br />
<br />
<script type="text/javascript">
	initializeDocument();
</script>
</div>
<div id="divtxtsql">
<span id="spantxtsql">
<?php print($txtLang['resultats']);?>
</span>
<br />
<br />
<?php
// Traitement du resultat
if (isset($serveur))
{
	$arrayIdS[] = $serveur;
	$arrayServeur=getProprieteServeurs($arrayIdS);
	
	// Cration d'une instance de l'objet
	$remoteSql = new myRemoteSql();
	// Dfinition des attributs
	$remoteSql->typeDatabase = "mysql";
		
	// Cration d'une instance de l'objet de Convertion du rsultat
	$convertion = new convertion();
	// Dfinition des attributs
	$convertion->skinHtml = " ";
	$convertion->typeSortie = "HTML";
	$convertion->preSortie = "S-SQL";
	
	switch ($action)
	{
		case "prs" : // Liste des processes

			// Excution du moteur de requtes SQL
			$arrayResultat = $remoteSql->executeSql($arrayServeur,"show processlist","S-SQL");
			
			// Conversion du rsultat
			$arrayResultatConvert = $convertion->convertResult($arrayResultat);
			$arrayHtml = $convertion->resultToHTMLData($arrayResultatConvert);
			$bRet = $convertion->resultToPrint($arrayHtml);
			break;
			
		case "tbl" : // Description de la table

			// Excution du moteur de requtes SQL
			$arrayResultat = $remoteSql->executeSql($arrayServeur,"show columns from ".$table,"S-SQL");
			
			// Conversion du rsultat
			$arrayResultatConvert = $convertion->convertResult($arrayResultat);
			$arrayHtml = $convertion->resultToHTMLData($arrayResultatConvert);
			$bRet = $convertion->resultToPrint($arrayHtml);
			break;
	}
}
?>
</div>
</body>
</html>