<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
/**
* AutoDiagnostic de l'application
*
* Ralise un diag de l'application, l'affichage est minimum
*
* @package MyRemoteSql
* @author MyRemoteSql
*/

class appDiag
{
	function executeDiag($pFichierConf)
	{
		$arrayRes = array();
		
		// Fichier de conf
		if( ! file_exists($pFichierConf))
		{
			$arrayRes[] = test_Is($pFichierConf,"E","Configuration");
			return $arrayRes;
		}
	
		if( ! is_readable($pFichierConf))
		{
			$arrayRes[] = test_Is($pFichierConf,"R","Configuration");
			return $arrayRes;
		}
	
		// include du fichier de conf
		include_once($pFichierConf);
		
		// Controle des Dossiers
		$arrayRes[] = $this->test_Is(DIRSKIN,"E","Dossier Skin");
		$arrayRes[] = $this->test_Is(DIRSKIN,"R","Dossier Skin");
		$arrayRes[] = $this->test_Is(DIRSKIN,"W","Dossier Skin");
		
		$arrayRes[] = $this->test_Is(DIRSKINHTML,"E","Dossier Skin Output");
		$arrayRes[] = $this->test_Is(DIRSKINHTML,"R","Dossier Skin Output");
	
		$arrayRes[] = $this->test_Is(DIRLANG,"E","Dossier Langage");
		$arrayRes[] = $this->test_Is(DIRLANG,"R","Dossier Langage");
		
		$arrayRes[] = $this->test_Is(DIRRESULT,"E","Dossier resultats");
		$arrayRes[] = $this->test_Is(DIRRESULT,"R","Dossier resulats");
		$arrayRes[] = $this->test_Is(DIRRESULT,"W","Dossier resulats");
				
		$arrayRes[] = $this->test_Is(DIRLOG,"E","Dossier Logs");
		$arrayRes[] = $this->test_Is(DIRLOG,"R","Dossier Logs");
		$arrayRes[] = $this->test_Is(DIRLOG,"W","Dossier Logs");
		
		$arrayRes[] = $this->test_Is("Lib","E","Dossier Lib");
		$arrayRes[] = $this->test_Is("Lib","R","Dossier Lib");
		
		$arrayRes[] = $this->test_Is("Alertes","E","Dossier Alertes");
		$arrayRes[] = $this->test_Is("Alertes","R","Dossier Alertes");
		
		$arrayRes[] = $this->test_Is("Trv","E","Dossier Trv");
		$arrayRes[] = $this->test_Is("Trv","R","Dossier Trv");
				
		// Controle des fichiers
		$arrayRes[] = $this->test_Is(FILEMENU,"E","Fichier menu");
		$arrayRes[] = $this->test_Is(FILEMENU,"R","Fichier menu");

		$arrayRes[] = $this->test_Is(FILEDENY,"E","Fichier Mots");
		$arrayRes[] = $this->test_Is(FILEDENY,"R","Fichier Mots");
		
		$arrayRes[] = $this->test_Is(FILESERVEUR,"E","Fichier definition serveurs");
		$arrayRes[] = $this->test_Is(FILESERVEUR,"R","Fichier definition serveurs");
			
		$arrayRes[] = $this->test_Is(FILESERVEUR,"E","Fichier definition serveurs");
		$arrayRes[] = $this->test_Is(FILESERVEUR,"R","Fichier definition serveurs");
		
		$arrayRes[] = $this->test_Is(FILESQLMODELE,"E","Fichier modele SQL");
		$arrayRes[] = $this->test_Is(FILESQLMODELE,"R","Fichier modele SQL");
		
		$arrayRes[] = $this->test_Is(FILETYPESORTIE,"E","Fichier types de sortie");
		$arrayRes[] = $this->test_Is(FILETYPESORTIE,"R","Fichier types de sortie");
		
		$arrayRes[] = $this->test_Is(FILEPRESORTIE,"E","Fichier des prsentations de sortie");
		$arrayRes[] = $this->test_Is(FILEPRESORTIE,"R","Fichier des prsentations de sortie");
		
		$arrayRes[] = $this->test_Is(FILEPERSO,"E","Fichier des infos personelles");
		$arrayRes[] = $this->test_Is(FILEPERSO,"R","Fichier des infos personelles");
	
		return $arrayRes;
	}
	/**
	* Fonction test_Is test si un dossier ou fichier existe, est accessisble en lecture ou criture
	*
	* Renvoi un tableau
	*
	* @param string Fichier ou dossier
	* @param string Mode (E)xiste (R)ead ou (W)rite
	*
	* @return array
	*/
	function test_Is($pFic,$pMode,$pLib)
	{
		$libMode="";
		
		switch ($pMode)
		{
		
			case "E":			// Existe
				$libMode = "Existance";
				
				if( ! file_exists($pFic))
				{
					return "Fichier Inexistant " . $pLib . " (" . $pFic . ")";
				}
					
				break;
			case "R":			// Lecture
				$libMode = "Lecture";
				
				if( ! is_readable($pFic))
				{
					return "Fichier Inaccessible en Lecture " . $pLib . " (" . $pFic . ")";
				}
			
				break;
				
			case "W":			// Ecriture
				$libMode = "Ecriture";
				
				if( ! is_writeable($pFic))
				{
					return "Fichier Inaccessible en Ecriture " . $pLib . " (" . $pFic . ")";
				}
			
				break;
		}
						
		return "$pLib : $pFic Ok mode : $libMode " ;
	}
}
// cration instance de diag
$diag = new appDiag();

// Excution du diag
$arrayDiag = $diag->executeDiag("mrsconf_inc.php");

// affichage Resultats
print("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr">
<head>
<title>
MyRemoteSQL - AutoDiag
</title>
</head>
<body>
<?php
print ("<h1>Mode AutoDiag</h1>");
print("<pre>");
print_r($arrayDiag);
print("Le mode AutoDiag est ON : voir le fichier de Conf.");
print("</pre>");
?>
</body>
</html>
