<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
/**
* Alertes
*
*
* @package MyRemoteSql
* @author MyRemoteSql
*/
include_once("Lib/entete_inc.php");
include_once("Lib/sql_inc.php");
include_once("Lib/myremotesql_class.php");
include_once("Lib/convertion_class.php");

print(afficheEntete());
print(afficheTitre("MyRemoteSQL - ".$txtLang['alertes']));

$noVersion = MYREMOTESQL_VERSION;

// Dfinition des tableaux
$arrayResultat = array();
$arrayResultatConvert = array();
$arrayHtml = array();
$arrayServeur =  array();
$arrayServeurUnit = array();
$proprieteServeur = array();
$arrayFicSql = array();
$arrayAff = array();
$arrayAlerte = array();

// Recup des serveurs
$arrayServeur = chargeArrayFromFic(FILESERVEUR);

// Rcup des fichiers alertes SQL
$arrayFicSql = chargeArrayFromDir(DIRALERTES);
$nbServeurs = count($arrayServeur);
$nbAlertes = count($arrayFicSql) * $nbServeurs;

// Cration d'une instance de l'objet
$remoteSql = new myRemoteSql();
// Dfinition des attributs
$remoteSql->typeDatabase = "mysql";
$remoteSql->texteSql = $txtsql;

// Cration d'une instance de l'objet de Convertion du rsultat
$convertion = new convertion();
// Dfinition des attributs
$convertion->skinHtml = " ";
$convertion->typeSortie = "TEXTE";
$convertion->preSortie = "S-SQL";

$nbAlerteDetectees = 0;
$nbErrConn = 0;

// Parcourt des serveurs
for ($i = 0; $i < count($arrayServeur); $i++)
{
	$arrayServeurUnit[0] = $arrayServeur[$i];
	$proprieteServeur = explode(";",$arrayServeur[$i]);
	
	$alerte = false;
	$connexionErreur = false;
		
	unset($arrayAlerte);
	
	// parcourt des requetes Alertes
	for ($j = 0; $j < count($arrayFicSql); $j++)
	{
		$sqlErreur = false;
		
		// Rcuperation de la clause SQL dans le fichier alerte
		$txtSql = getFicContenu($arrayFicSql[$j][0]);

		// Excution du moteur de requtes SQL
		$arrayResultat = $remoteSql->executeSql($arrayServeurUnit,$txtSql,"S-SQL");
		
		// Conversion du rsultat
		$arrayResultatConvert = $convertion->convertResult($arrayResultat);
//print_r($arrayResultatConvert);
		
		for ($k = 0; $k < count($arrayResultatConvert); $k++)
		{
			$chaine = "*" . substr($arrayResultatConvert[$k],MRSLGCODE,strlen($arrayResultatConvert[$k]) - MRSLGCODE);
			$code   = "*" . substr($arrayResultatConvert[$k],0,MRSLGCODE);
			
			// Erreur Connexion prsente ???				
			if (strpos($code,"CNXERR") == 1)
			{
				$connexionErreur = true;	
				$arrayAlerte[] = $chaine;
				
			}
			// Erreur SQL ???				
			if (strpos($code,"REQERR") == 1)
			{
				$sqlErreur = true;	
				$arrayAlerte[] = $chaine;
			}
			// Alerte prsente ???				
			if (strpos($chaine,MRSALERTECODE) == 2)
			{
				$alerte = true;	
				$arrayAlerte[] = $chaine;
				$nbAlerteDetectees = $nbAlerteDetectees + 1;
			}
		}
	}	
	// Rsultat
	if ($alerte)
	{
		$arrayAff[] = "<img src=\"Img/alerte.gif\" alt=\"Alerte\" />" . $proprieteServeur[1];	
		for ($k = 0; $k < count($arrayAlerte); $k++)
		{
			$arrayAff[] = $arrayAlerte[$k];
		}
	}
	else
	{
		if ($connexionErreur)
		{
			$arrayAff[] =  "<img src=\"Img/alerte.gif\" alt=\"Connexion erreur\" />" . $proprieteServeur[1];	
			for ($k = 0; $k < count($arrayAlerte); $k++)
			{
				$arrayAff[] = $arrayAlerte[$k];
			}
			$nbErrConn = $nbErrConn + 1;
		}
		else
		{
			if ($sqlErreur)
			{
				$arrayAff[] =  "<img src=\"Img/alerte.gif\" alt=\"Sql erreur\" />" . $proprieteServeur[1];	
				for ($k = 0; $k < count($arrayAlerte); $k++)
				{
					$arrayAff[] = $arrayAlerte[$k];
				}
			}
			else
			{
				$arrayAff[] =  "<img src=\"Img/noalerte.gif\" alt=\"OK\" />" . $proprieteServeur[1];
			}
		}
	}
// Fin parcourt serveurs
}
// Affichage cran de sortie
print("<div id=\"divresultats\">\n");
print("<span id=\"spanresultats\">\n");
print($txtLang['resultats']);
print("</span>\n");
print("<br />\n");
print("<br />\n");
print($txtLang['alertes'] . " : " . $nbAlerteDetectees . " / " . $nbAlertes . "  " . $txtLang['errconnexion'] . " : " . $nbErrConn . " / " . $nbServeurs . "\n");
print("</div>\n");
print("<div id=\"divresultatsdata\">\n");
print("<pre>\n");
$bRet = $convertion->resultToPrint($arrayAff);
print("</pre>\n");
print("</div>\n");
?>
</body>
</html>