<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
/**
* Affichage des fichiers rsultats
*
* Liste le rpertoire rsultats
*
* @package MyRemoteSql
* @author MyRemoteSql
*/
include_once("Lib/entete_inc.php");
print("<script language=\"javascript\" type=\"text/javascript\" src=\"Lib/sorttable.js\"></script>\n");
print(afficheEntete());
print(afficheTitre("MyRemoteSQL - ".$txtLang['fichierresultat']));

// Test le rpertoire existe pour affichage
if (file_exists(DIRRESULT))
{
	// Chargement des infos des fichiers dans tableau
	$arrayResult = array();
	$arrayResult = chargeArrayFromDir(DIRRESULT);
	
	if ( ! is_array($arrayResult))
	{
		$arrayResult = array();
	}
	//
	print("<div id=\"divresultatsdata\">\n");
	print("<span id=\"spanresultats\">");
	print($txtLang['resultats']);
	print("</span>\n");
	print("<br />\n");
	print("<br />\n");
	print("<table class=\"sortable\" id=\"tblresult\" border=\"1\" >\n");
	print("<tr>\n");
	print("<th>".$txtLang['fichier']."</th>\n");
	print("<th>".$txtLang['taille']."</th>\n");
	print("<th>".$txtLang['datemodif']."</th>\n");
	print("</tr>\n");
	
	//	Affichage des fichiers du rpertoire
	foreach ( $arrayResult as $arrayDir )
	{
		print("<tr>\n");
		print("<td><a href=\"$arrayDir[0]\"> $arrayDir[0] </a></td>\n");
		print("<td>$arrayDir[1]</td>\n");
		print("<td>$arrayDir[2]</td>\n");
		print("</tr>");
	}
	print("</table>\n");
}
else
{
	print("<div id=\"divresultatsdata\">\n");
	print($txtLang['repertoire'] . " ".DIRRESULT .$txtLang['inexistant']." ...\n");
	print("</div>\n");
}
?>
</div>
</body>
</html>