<?php
/**
* Classe Excution des requtes SQL
*
*
* @package MyRemoteSql
* @author MyRemoteSql
*/
class myRemoteSql
{
	var $typeDatabase = "mysql";
	var $texteSql = " ";
		
	///////////////////////////// Excution de requtes /////////////////////////////////////////////

	/**
	* Fonction executeSQL
	*
	* Fonction Aiguillage
	*
	* @param array Liste de serveur
	* @param string requete SQL
	* @param string Presentation
	*
	* @return array
	*/
	function executeSql($plisteServeurs,$ptxtSql,$pPresentation)
	{
		switch ($this->typeDatabase)
		{
			// Moteur MySql
			case "mysql":
				if (trim($pPresentation) == "S-SQL")
				{
					return $this->executeMySql ($plisteServeurs,$ptxtSql);
				}
				else
				{
					return $this->executeMySql2 ($plisteServeurs,$ptxtSql);
				}
				break;
			
			default:
				if (trim($pPresentation) == "S-SQL")
				{
					return $this->executeMySql ($plisteServeurs,$ptxtSql);
				}
				else
				{
					return $this->executeMySql2 ($plisteServeurs,$ptxtSql);
				}
				break;
		}
	}
	
	/**
	* Fonction executeMySQL
	*
	* Fonction principale d'excution de requtes
	*
	* @param array Liste de serveurs
	* @param string requete SQL
	*
	*
	* @return array
	*/
	function executeMySql($plisteServeurs,$ptxtSql)
	{
		global $txtLang;
		
		//*****  Parcourt des Serveurs Slectionns
		
		foreach ($plisteServeurs as $serveur)
		{
			$selectsql = true;
											
			$arrayResult [] = dimLgCode("S") . $txtLang['debutsessionserveur'];
			$attServeur = explode(";",$serveur);
			$arrayResult [] = dimLgCode("I") .  date(LNGDATEHMS). " " .$txtLang['connexionserveur']. " " . $attServeur[1]. " Ip : " . $attServeur[2]. " Port : ".$attServeur[3]." Base : ".$attServeur[4]." User : ".$attServeur[5];	
			$arrayResult [] = dimLgCode("IDS") . $attServeur[1];
			
			// Connexion SQL serveur
			$arrayResult [] = dimLgCode("CNX");
			$arrayResult [] = dimLgCode("CNXDAT") . date(LNGDATEHMS);
			$arrayResult [] = dimLgCode("CNXIP") .  $attServeur[1];
			$arrayResult [] = dimLgCode("CNXPOR") . $attServeur[2];
			$arrayResult [] = dimLgCode("CNXDB") .  $attServeur[3];
			$arrayResult [] = dimLgCode("CNXUSR") .  $attServeur[4];
			
			$connexion = connectServeur($attServeur[2],$attServeur[3],$attServeur[5],$attServeur[6]);
			if ($connexion == false) 
			{
				$arrayResult [] = dimLgCode("CNXERR") . $txtLang['errconnexion']." ".$attServeur[1]. " Ip : " . $attServeur[2]. "    Port : ".$attServeur[3]." Base : ".$attServeur[4]." User : ".$attServeur[5]."   ".mysql_error();
				$arrayResult [] = dimLgCode("CNXFIN");
				$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
				continue;
			}			

			// Selection de la base
			$ret = connectBase($connexion,$attServeur[4]);
			if ($ret == false)
			{
				$arrayResult [] = dimLgCode("CNXERR") . $txtLang['errselectionbase'] ." ".$attServeur[4]." ".mysql_error();
				$arrayResult [] = dimLgCode("CNXFIN");
				$arrayResult [] = dimLgCode("SF") .  $txtLang['finsessionserveur'];
				continue;
			}
			$arrayResult [] = dimLgCode("CNXFIN");
				
			// Rcupration des multi-requtes
			$arraySql = explode(";",$ptxtSql);
		
			if (strlen(trim($arraySql[count($arraySql) - 1 ])) == 0)
			{
				$fin = count($arraySql) -2;
			}
			else
			{
				$fin = count($arraySql) -1;
			}

			// Boucle sur les Requtes SQL
			for ($ind=0;$ind <= $fin; $ind++)
			{
				$arrayResult [] = dimLgCode("R") . $txtLang['requetesql'];
				$arrayResult [] = dimLgCode("REQTXT") . $arraySql[$ind];
				
				// Excution de la requete
				$selectsql = true;
				
				$resultat = @mysql_query($arraySql[$ind]);
				if ($resultat == false)
				{
					// erreur d'excution SQL
					$arrayResult [] = dimLgCode("E") . $txtLang['errexecutesql'] . " : ".$arraySql[$ind];
					
					$msg = mysql_error();
					$msg2 = mysql_errno();
					settype($msg2,"string");
					$msg = $msg . "  Erreur No " . $msg2;
			
					$arrayResult [] = dimLgCode("REQERR") . $msg;
					$arrayResult [] = dimLgCode("RF") . $txtLang['finrequete'];
					continue;
				}	
			
				$nbre = @mysql_num_rows($resultat);
				if ($nbre == false)
				{	
					$nbre = mysql_affected_rows();
					$selectsql=false;
				}
				$arrayResult [] = dimLgCode("REQNBR") . $nbre;
							
				// Si Select ...
				if ($selectsql)
				{
					// Affichage de l'entete des rsultats
					$champs="";
					
					// Affichage des noms des champs
					for ($i = 1; $i <= mysql_num_fields($resultat); $i++)
					{
						// Rcup du nom du champ
						$champs = $champs . mysql_field_name($resultat, $i - 1 ) . SEPARATEUR;
					}
					$champs = substr($champs,0,strlen($champs) - 1);
					
					$arrayResult [] = dimLgCode("C") .$champs;
															
					// Parcourt du curseur SQL pour affichage des donnes
					for($i = 0; $i < $nbre; $i++)
					{
						$record = "";
						
						$row = mysql_fetch_row($resultat);
						$msg = "";
						
						// Parcourt de chaque champ
						foreach ($row as $field)
						{
							$record = $record . (strlen(trim($field)) == 0 ? " " : $field) . SEPARATEUR ;
						}
						$record = substr($record,0,strlen($record) - 1);
						
						$arrayResult [] = dimLgCode("D") . $record;						
					}
						
				// Fin de SI select ...	
				}			
			// Fin de Boucle sur les Requtes
			$arrayResult [] = dimLgCode("RF") . $txtLang['finrequete'];
			}
			// dconnexion de la base
			mysql_close($connexion);
			
			$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
			
		// Fin de boucle des serveurs
		}
		
		$arrayResult [] = dimLgCode("I") . $txtLang['fintraitement'] ." " . date(LNGDATEHMS);
		
		// Ecriture Fin de fichier
		$arrayResult [] = dimLgCode("F");
		
		return $arrayResult;
	}
	
	/**
	* Fonction executeMySQL2
	*
	* Fonction principale d'excution de requtes
	*
	* @param array Liste de serveurs
	* @param string requete SQL
	*
	*
	* @return array
	*/
	function executeMySql2($plisteServeurs,$ptxtSql)
	{
		global $txtLang;
						
		// Rcupration des multi-requtes
		$arraySql = explode(";",$ptxtSql);
	
		if (strlen(trim($arraySql[count($arraySql) - 1 ])) == 0)
		{
			$fin = count($arraySql) -2;
		}
		else
		{
			$fin = count($arraySql) -1;
		}

		// Boucle sur les Requtes SQL
		for ($ind=0;$ind <= $fin; $ind++)
		{
			$arrayResult [] = dimLgCode("R") . $txtLang['requetesql'];
			$arrayResult [] = dimLgCode("REQTXT") . $arraySql[$ind];
			
			// Excution de la requete
			$selectsql = true;
			
				//*****  Parcourt des Serveurs Slectionns
				foreach ($plisteServeurs as $serveur)
				{
					$selectsql = true;
													
					$arrayResult [] = dimLgCode("S") . $txtLang['debutsessionserveur'];
					$attServeur = explode(";",$serveur);
					$arrayResult [] = dimLgCode("I") .  date(LNGDATEHMS). " " .$txtLang['connexionserveur']." ".$attServeur[1]. " Ip : " . $attServeur[2]. " Port : ".$attServeur[3]." Base : ".$attServeur[4]." User : ".$attServeur[5];	
					$arrayResult [] = dimLgCode("IDS") .$attServeur[1];
					
					// Connexion SQL serveur
					$arrayResult [] = dimLgCode("CNX");
					$arrayResult [] = dimLgCode("CNXDAT") . date(LNGDATEHMS);
					$arrayResult [] = dimLgCode("CNXIP") .  $attServeur[1];
					$arrayResult [] = dimLgCode("CNXPOR") . $attServeur[2];
					$arrayResult [] = dimLgCode("CNXDB") .  $attServeur[3];
					$arrayResult [] = dimLgCode("CNXUSR") .  $attServeur[4];
					
					$connexion = connectServeur($attServeur[2],$attServeur[3],$attServeur[5],$attServeur[6]);
					if ($connexion == false) 
					{
						$arrayResult [] = dimLgCode("CNXERR") . $txtLang['errconnexion']." ".$attServeur[1]. " Ip : " . $attServeur[2]. "    Port : ".$attServeur[3]." Base : ".$attServeur[4]." User : ".$attServeur[5]."   ".mysql_error();
						$arrayResult [] = dimLgCode("CNXFIN");
						$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
						continue;
					}			
		
					// Selection de la base
					$ret = connectBase($connexion,$attServeur[4]);
					if ($ret == false)
					{
						$arrayResult [] = dimLgCode("CNXERR") . $txtLang['errselectionbase'] ." ".$attServeur[4]." ".mysql_error();
						$arrayResult [] = dimLgCode("CNXFIN");
						$arrayResult [] = dimLgCode("SF") .  $txtLang['finsessionserveur'];
						continue;
					}
					$arrayResult [] = dimLgCode("CNXFIN");

					// 
					$resultat = @mysql_query($arraySql[$ind]);
					if ($resultat == false)
					{
						// erreur d'excution SQL
						$arrayResult [] = dimLgCode("E") . $txtLang['errexecutesql'] . " : ".$arraySql[$ind];
						
						$msg = mysql_error();
						$msg2 = mysql_errno();
						settype($msg2,"string");
						$msg = $msg . "  Erreur No " . $msg2;
				
						$arrayResult [] = dimLgCode("REQERR") . $msg;
						$arrayResult [] = dimLgCode("RF") . $txtLang['finrequete'];
						continue;
					}	
				
					$nbre = @mysql_num_rows($resultat);
					if ($nbre == false)
					{	
						$nbre = mysql_affected_rows();
						$selectsql=false;
					}
					$arrayResult [] = dimLgCode("REQNBR") . $nbre;
					$arrayResult [] = dimLgCode("I") . $nbre." ".$txtLang['enregistmaj'];
				
					// Si Select ...
					if ($selectsql)
					{
						// Affichage de l'entete des rsultats
						$champs="";
						
						// Affichage des noms des champs
						for ($i = 1; $i <= mysql_num_fields($resultat); $i++)
						{
							// Rcup du nom du champ
							$champs = $champs . mysql_field_name($resultat, $i - 1 ) . SEPARATEUR;
							
						}
						$champs = substr($champs,0,strlen($champs) - 1);
						
						$arrayResult [] = dimLgCode("C") .$champs;
																
						// Parcourt du curseur SQL pour affichage des donnes
						for ($i = 0; $i < $nbre; $i++)
						{
							$record = "";
							
							$row = mysql_fetch_row($resultat);
							$msg = "";
							
							// Parcourt de chaque champ
							foreach ($row as $field)
							{
								$record = $record . (strlen(trim($field)) == 0 ? " " : $field) . SEPARATEUR ;
							}
							$record = substr($record,0,strlen($record) - 1);
							
							$arrayResult [] = dimLgCode("D") . $record;						
						}
							
					// Fin de SI select ...	
					}			
				// dconnexion de la base
				mysql_close($connexion);
			
				$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
			
				// Fin de boucle des serveurs
				}
										
			// Fin de Boucle sur les Requtes
			$arrayResult [] = dimLgCode("RF") . $txtLang['finrequete'];
		}
				
		$arrayResult [] = dimLgCode("F") . $txtLang['fintraitement'] ." " . date(LNGDATEHMS);
		
		// Ecriture Fin de fichier
		$arrayResult [] = dimLgCode("F");
		
		return $arrayResult;
	}
	
	///////////////////////////// Comparaison de Bases /////////////////////////////////////////////
	
	/**
	* Fonction compareBaseSql
	*
	* Fonction Aiguillage
	*
	* @param array Liste de serveurs
	* @param string Serveur de rfrence
	*
	* @return array
	*/
	function compareBaseSql ($plisteServeurs,$pServeurRef)
	{
		switch ($this->typeDatabase)
		{
			// Moteur MySql
			case "mysql":
				return $this->compareBaseMySql($plisteServeurs,$pServeurRef);
				break;
			
			default:
				return $this->compareBaseMySql($plisteServeurs,$pServeurRef);
				break;
		}
	}
	/**
	* Fonction verifOrdreChamps
	*
	* Fonction de vrification de l'ordre des champs
	*
	* @param array tableau 1 de champs
	* @param array tableau 2 de champs
	*
	* @return array  un tableau contenant les diffrences
	*/
	function verifOrdreChamps($pchamps1,$pchamps2)
	{
		$nbre = count($pchamps1);
		
		for($i=0;$i < $nbre;$i++)
		{
			$tmp1 = $pchamps1[$i][0];
			$tmp2 = $pchamps2[$i][0];
	
			if ($tmp1 != $tmp2)
			{
				$tmpChamps[$i] = $pchamps1[$i][0] . " - " . $pchamps2[$i][0];
			}
		}
		return $tmpChamps;
	}
	
	/**
	* Fonction analyseChamps
	*
	* Fonction d'Analyse les champs communs : porte sur le type, la longueur et	les attributs
	*
	* @param array tableau 1 de champs
	* @param array tableau 2 de champs
	*
	*					$pa1[1][0] 	: nom champs
	*					$pa1[1][1]	: type champs	
	*					$pa1[1][2]	: longueur du champs
	*					$pa1[1][3]	: Attributs	
	* @return array  un tableau contenant les diffrences
	*/
	function analyseChamps($pa1,$pa2)
	{
		global $txtLang;
		
		for($i=0;$i < count($pa1);$i++)
		{
			$trouve = false;
			for($j=0;$j < count($pa2); $j++)
			{
				$motif = "";
	
				// le champ est trouv
				if ( trim($pa1[$i][0]) == trim($pa2[$j][0]))
				{
					// Comparaison du Type
					if ($pa1[$i][1] != $pa2[$j][1])
					{
						$motif = $txtLang['champ'] . $pa1[$i][0] . " : " . $txtLang['typediff'] . " " . $pa1[$i][1] . "!=" . $pa2[$j][1];
					}
					// Comparaison de la longueur
					if ($pa1[$i][2] != $pa2[$j][2])
					{
						$motif = $motif .$txtLang['champ'] . " " . $pa1[$i][0] . " : " . $txtLang['longueurdiff'] . " " . $pa1[$i][2] . "!=" . $pa2[$j][2];
					}
					// Comparaison des attributs du champs
					if ($pa1[$i][3] != $pa2[$j][3])
					{
						$motif =  $motif .$txtLang['champ']." " . $pa1[$i][0] . " : ".$txtLang['attrributsdiff'] ." " .$pa1[$i][3] . "!=" .$pa2[$j][3];
					}
					// Stockage des diffrences
					if (trim($motif) != "")
					{
						$tmparray[] = $motif;
					}
				}
			}
		}
		return $tmparray;
	}
	
	/**
	* Fonction compareBaseMySql
	*
	* Fonction de comparaison de base MySql
	*
	* @param array tableau des serveurs  comparer
	* @param string Serveur de rfrence
	*
	* @return array  un tableau contenant le rsultat
	*/
	function compareBaseMySql ($pListeServeurs,$pServeurRef)
	{
		global $txtLang;
		
		// Connexion serveur de Rfrence
		$arrayResult [] = dimLgCode("S") . $txtLang['debutsessionserveur'];
		$arrayResult [] = dimLgCode("I") . $txtLang['connexionserveurrf'];	
	
		$attServeurref = explode(";",$pServeurRef);

		$arrayResult [] = dimLgCode("I") . date(LNGDATEHMS) . " " . $txtLang['connexionserveur'] . " : " . $attServeurref[1]. " Ip : " . $attServeurref[2] .  "  Port : " . $attServeurref[3] . " Base : " . $attServeurref[4] . " User : " . $attServeurref[5];

		$arrayResult [] = dimLgCode("CNX");
		$arrayResult [] = dimLgCode("CNXDAT") . date(LNGDATEHMS);
		$arrayResult [] = dimLgCode("CNXIP") .  $attServeurref[1];
		$arrayResult [] = dimLgCode("CNXPOR") . $attServeurref[2];
		$arrayResult [] = dimLgCode("CNXDB") .  $attServeurref[3];
		$arrayResult [] = dimLgCode("CNXUSR") . $attServeurref[4];
		
		$connexionref = connectServeur($attServeurref[2],$attServeurref[3],$attServeurref[5],$attServeurref[6]);
		
		if ($connexionref == false) 
		{
			$arrayResult [] = dimLgCode("CNXERR") . $txtLang['errconnexion'] . " " . $attServeurref[1] . " Ip : " . $attServeurref[2] . " Port : ".$attServeurref[3]." Base : " . $attServeurref[4] . " User : " . $attServeurref[5] . " " . mysql_error();
			$arrayResult [] = dimLgCode("CNXFIN");
			$arrayResult [] = dimLgCode("E") . $txtLang['errfatale'] . " " . $txtLang['connexionserveurrf'];
			$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
			return $arrayResult;
		}			
	
		// Selection de la base de rfrence
		$ret = connectBase($connexionref,$attServeurref[4]);
		if ($ret == false)
		{
			$arrayResult [] = dimLgCode("CNXERR") . $txtLang['errselectionbase'] . " " . $attServeurref[4] . " " . mysql_error();
			$arrayResult [] = dimLgCode("CNXFIN");
			$arrayResult [] = dimLgCode("E") . $txtLang['errfatale'] . " " . $txtLang['errselectionbase'];
			$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
			return $arrayResult;
		}
		$arrayResult [] = dimLgCode("CNXFIN");
		$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
			
		//*****  Parcourt des Serveurs Selectionns pour comparaison
		foreach ($pListeServeurs as $serveur)
		{
			$arrayResult [] = dimLgCode("S") . $txtLang['debutsessionserveur'];
			$attServeur = explode(";",$serveur);
			$arrayResult [] = dimLgCode("I") . date(LNGDATEHMS). " ". $txtLang['connexionserveur'] . " " . $attServeur[1] . " Ip : " . $attServeur[2] . " Port : " . $attServeur[3] . " Base : " . $attServeur[4] . " User : " . $attServeur[5];	
						
			$arrayResult [] = dimLgCode("CNX");
			$arrayResult [] = dimLgCode("CNXDAT") . date(LNGDATEHMS);
			$arrayResult [] = dimLgCode("CNXIP") .  $attServeur[1];
			$arrayResult [] = dimLgCode("CNXPOR") . $attServeur[2];
			$arrayResult [] = dimLgCode("CNXDB") .  $attServeur[3];
			$arrayResult [] = dimLgCode("CNXUSR") .  $attServeur[4];
			// Connexion serveur  comparer
			$connexion = connectServeur($attServeur[2],$attServeur[3],$attServeur[5],$attServeur[6]);
			if ($connexion == false) 
			{
				$arrayResult [] = dimLgCode("CNXERR") . $txtLang['errconnexion'] . " " . $attServeur[2] . " Ip : " . $attServeur[2] . "    Port : " . $attServeur[3] . " Base : " . $attServeur[4] . " User : " .$attServeur[5] . "   " . mysql_error();
				$arrayResult [] = dimLgCode("CNXFIN");
				$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
				continue;
			}			

			// Selection de la base  comparer
			$ret = connectBase($connexion,$attServeur[4]);
			if ($ret == false)
			{
				$arrayResult [] = dimLgCode("CNXERR") . $txtLang['errselectionbase'] . " " . $attServeur[4] . " " . mysql_error();
				$arrayResult [] = dimLgCode("CNXFIN");
				$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
				continue;
			}
			
			$arrayResult [] = dimLgCode("CNXFIN");
			
			// Liste des tables de la base de rfrence
			$listetables1 = getDbTables($connexionref,$attServeurref[4]);
			
			$arrayResult [] = dimLgCode("TR");
			$arrayResult [] = dimLgCode("I") . $txtLang['tablesbaseref'] ." : " . count($listetables1);

			for($i=0;$i < count($listetables1);$i++)
			{
				$arrayResult [] = dimLgCode("TBL") . $listetables1[$i] ;
			}
			$arrayResult [] = dimLgCode("TRF");
			
			// Liste des tables de la base vrifie
			$listetables2 = getDbTables($connexion,$attServeur[4]);
			
			$arrayResult [] = dimLgCode("TB");
			$arrayResult [] = dimLgCode("I") . $txtLang['tablesbaseverif'] . " : " . count($listetables2) ;
			
			for($i=0;$i < count($listetables2);$i++)
			{
				$arrayResult [] = dimLgCode("TBL") . $listetables2[$i] ;
			}
			$arrayResult [] = dimLgCode("TBF");
		
			// diffrence de table
			$tablesDiff1 = getArrayDiff($listetables1,$listetables2);
			$tablesDiff2 = getArrayDiff($listetables2,$listetables1);
			
			// Diffrence
			$arrayResult [] = dimLgCode("T+");

			$arrayResult [] = dimLgCode("I") . $txtLang['tablesdiff+'] . " : " .  count($tablesDiff2) ;
			
			for($i=0;$i < count($tablesDiff2);$i++)
			{
				$arrayResult [] = dimLgCode("TBL") . $tablesDiff2[$i];
			}
			$arrayResult [] = dimLgCode("T+F");
			
			// Diffrence
			$arrayResult [] = dimLgCode("T- ");

			$arrayResult [] = dimLgCode("I") . $txtLang['tablesdiff-']." : ". count($tablesDiff1) ;
			
			for($i=0;$i < count($tablesDiff1);$i++)
			{
				$arrayResult [] = dimLgCode("TBL") . $tablesDiff1[$i];
			}
			$arrayResult [] = dimLgCode("T-F");
			
			// Liste des tables communes
			$tables = getArrayIntersect($listetables1,$listetables2);
			
			$arrayResult [] = dimLgCode("TC");

			$arrayResult [] = dimLgCode("I") . $txtLang['tablescomm'] . " : " . count($tables) ;
			
			for($i=0;$i < count($tables);$i++)
			{
				$arrayResult [] = dimLgCode("TBL") . $tables[$i];
			}
			$arrayResult [] = dimLgCode("TCF");

			// Analyse de chaque table : rcup des champs pour chaque table
			for($ind=0;$ind < count($tables);$ind++)
			{
				if (trim($tables[$ind]) == "")
				{
					continue;
				}
				$arrayResult [] = dimLgCode("TY") . $tables[$ind];

				$arrayResult [] = dimLgCode("I") . $txtLang['tablesanalyse'] . " : " . $tables[$ind];
				
				$champs1 = getTableChamps($connexionref,$attServeurref[4],$tables[$ind]);
				$champs2 = getTableChamps($connexion,$attServeur[4],$tables[$ind]);

				// le nombre de champs est gal
				if (count($champs1) == count($champs2))
				{
					$arrayResult [] = dimLgCode("I") . $txtLang['champsnbegal'];
					$diffordrechamps = $this->verifOrdreChamps($champs1,$champs2);
					
					// Affichage des diffrences
					$arrayResult [] = dimLgCode("I") .$txtLang['champsdiff']." : ";
					for($j=0;$j < count($diffordrechamps);$j++)
					{
						$arrayResult [] = dimLgCode("I") . $diffordrechamps[$j];
					}
				}
				// le nombre de champs est diffrent
				else
				{
					$arrayResult [] = dimLgCode("I") . $txtLang['champsnbdiff'];
					for($i=0;$i < count($champs1);$i++)
						$champsnom1[$i] = $champs1[$i][0];
			
					for($i=0;$i < count($champs2);$i++)
						$champsnom2[$i] = $champs2[$i][0];
						
					$champsDiff1 = getArrayDiff($champsnom1,$champsnom2);
					$champsDiff2 = getArrayDiff($champsnom2,$champsnom1);
				
					$arrayResult [] = dimLgCode("C+");

					$arrayResult [] = dimLgCode("I") . $txtLang['champsdiff+'] . " " . count($champsDiff1);
					for($i=0;$i < count($champsDiff1);$i++)
					{
						$arrayResult [] = dimLgCode("FLD") . $champsDiff1[$i] ;
					}
					$arrayResult [] = dimLgCode("C+F");

					$arrayResult [] = dimLgCode("C-");

					$arrayResult [] = dimLgCode("I") .$txtLang['champsdiff-'] . " " . count($champsDiff2);
					for($i=0;$i < count($champsDiff2);$i++)
					{
						$arrayResult [] = dimLgCode("FLD") . $champsDiff2[$i];
					}
					$arrayResult [] = dimLgCode("C-F");
				}
				
				$champs = getArrayIntersect($champs1,$champs2);
								
				$arrayResult [] = dimLgCode("I") . $txtLang['champscommunsanalyse'];
				$champsdiff = $this->analyseChamps($champs1,$champs2);
				
				for($i=0;$i < count($champsdiff);$i++)
				{
					$arrayResult [] = dimLgCode("FLD") . $champsdiff[$i];
				}
				
				$arrayResult [] = dimLgCode("TYF"). $tables[$ind];;

			// Fin de boucle sur tables
			}

			// dconnexion de la base  comparer
			//mysql_close($connexion);
			
			$arrayResult [] = dimLgCode("SF") . $txtLang['finsessionserveur'];
			
		// Fin de boucle des serveurs
		}
		
		// dconnexion de la base de rfrence
		mysql_close($connexionref);
				
		$arrayResult [] = dimLgCode("I") . $txtLang['fintraitement'] . " " . date(LNGDATEHMS);
		
		return $arrayResult;
	}
}
?>