<?php
/*
Nom :		readinifile
Description :	Classe Permettant de gerer un fichier au format ini. Utile pour editer des configurations d'appli php. Ajouter/supprimer une section, Ajouter/supprimer une cl d'une section, editer une cl/value...
Auteur :	Fred Girard <fred.girard@free.fr>
URL :		http://www.phpscripts-fr.net/portions/portion.php?id=65
**
* Rcupre sous forme de tableau un fichier ini  
* Utilisation ex :
*
* $config = new readinifile(CONFIG_DIR."conf_sgbd.ini"); 
* $config->get_namesection(0); //retourne le nom de la premiere section du fichier
* $config->get_value("sejours","key")); //retourne la valeur de "key" pour la section "[sejours]"
* $config->add_section("test"); //ajoute une section "[test]"
* $config->add_key("sejours","test","1");// ajoute une cl/valeur "test = 1" dans la section "[sejours]" 
*
*
* @access public
* @version $Id$
* @package File
* @author Fred
*/
class readinifile{
	var $ini_array;
	var $file ;
	var $sectionlist;
/*****************************************************
* Method : Constructeur
*@param : string $file chemein complet du fichier ini a parser
*@return:
*******************************************************/
	function readinifile($file){
		if (is_readable($file)){
			$this->ini_array = parse_ini_file($file, TRUE);
			if(is_array($this->ini_array)){
				$this->make_sectionlist();	
			}
		$this->file = $file;
		}else{
			echo "Le fichier $file est introuvable !<br />";
		}
	}
	
/*****************************************************
* Method : Constructeur
*@param : string $file chemein complet du fichier ini a parser
*@return:
*******************************************************/
	function resetinifile(){
		$file = $this->file;
		if (file_exists($file)){
			$this->ini_array = parse_ini_file($file, TRUE);
			if(is_array($this->ini_array)){
				$this->make_sectionlist();	
			}
		$this->file = $file;
		}else{
			echo "Le fichier $file est introuvable !<br />";
		}
	}

/*****************************************************
* Method : Construit une liste de section du fichier ini
*@return:
*******************************************************/	
	function make_sectionlist(){
		$this->sectionlist = array();
		while (list($k, $v) = each ($this->ini_array)){        
			$this->sectionlist[] = $k;    
		}	
	}
	
/*****************************************************
* Method : Rcupre le nom d'une section
*@param : integer $id_section index du tableau construit make_sectionlist
*@return: string nom de la section
*******************************************************/
	function get_namesection($id_section){
		return $this->sectionlist[$id_section];
	}
	
/*****************************************************
* Method : Rcupre sous forme de tableau une section
*@param : string $name_section nom de la section
*@return: array 
*******************************************************/
	function get_section($name_section){
		return $this->ini_array[$name_section];
	}
	
/*****************************************************
* Method : Retourne le nombre de section
*@return: integer
*******************************************************/
	function get_countsection(){
		return count($this->ini_array);	
	}
	
/*****************************************************
* Method : Rcupre la valeur d'une cl dans une section
*@param : string $section_name Nom de la section
*@param : string $key Cl de la valeur recherche
*@return: mixed Valeur de cl recherche
*******************************************************/
	function get_value($section_name,$key){		
		if(strtolower($this->ini_array[$section_name][$key])=="false") return false;
		if(strtolower($this->ini_array[$section_name][$key])=="true") return true;
		return $this->ini_array[$section_name][$key];
	}

/*****************************************************
* Method : Ajoute une section dans le fichier ini 
*@param : string $name NOm de la section a ajouter
*@return: boolean Renvoi true si section ajoute
*******************************************************/
	function add_section($name){
		$f = fopen($this->file,"a+");	
		if(!fwrite($f, "\r\n[".$name."]\r\n")) {
			print "Impossible d'crire dans le fichier ($this->file)";
			return false ;    
		}
		fclose($f);
		$this->resetinifile();
		return true;
	}
	
/*****************************************************
* Method : Supprime une section dans le fichier ini 
*@param : string $name NOm de la section a ajouter
*@return: boolean Renvoi true si section ajoute
*******************************************************/
	function drop_section($name){
		$filesize = filesize ($this->file);	
		$fd = fopen ($this->file, "r");
		$i = 1;
		 while (!feof ($fd)) {
		 	$tmp_str = fgets($fd, 4096);
		 	if(ereg("\[".$name."\]",$tmp_str)){
		 		$seek = $i;	
		 		continue;
		 	}
		 	if($seek && ereg("\[.*\]",$tmp_str) && !$endseek){
		 		$endseek = $i;	
		 		echo "ok";
		 	}		 	
		 	$str_file []= $tmp_str; 
		 	$i++;
		 }
		 fclose($fd);
		 if(!$endseek) $endseek = $i;
		 
		 if($seek){
		 	echo "seek = $seek et endseek = $endseek";
	  		 $f = fopen ($this->file, "w");   
	  		 for ($k=0;$k<sizeof($str_file);$k++){
	  			if($k >= $seek-1 && $k < $endseek-1){
	  				//rien
	  			}else{	
	  				fwrite ($f,$str_file[$k]);
	  			} 
	  		 }
	  		 fclose ($f);
	  	 }else{
	  		return false;
		 } 
		$this->resetinifile();
		return true;
	}
	
/*****************************************************
* Method : Ajout un cl/valeur dans une section
*@param : string $sectionname Nom de la section
*@param : string $key Nom de la cl a ajouter
*@param : string $value Valeur de la cl
*@param : string $type Type de valeur Default string
*@return: boolean Si la section est introuvable renvoit false, sinon true
*******************************************************/
	function add_key($sectionname,$key,$value,$type="string"){
		$filesize = filesize ($this->file);	
		$fd = fopen ($this->file, "r");
		$i = 1;
		 while (!feof ($fd)) {
		 	$tmp_str = fgets($fd, 4096);
		 	if(ereg("\[".$sectionname."\]",$tmp_str)){
		 		$seek = $i;	
		 	}		 	
		 	$str_file []= $tmp_str; 
		 	$i++;
		 }
		 fclose($fd);
		 if($seek){
			 if($type=="string"){
			 	 $str_file[$seek - 1] .= $key." = \"".$value."\"\n";
			 }else{
			 	 $str_file[$seek - 1] .= $key." = ".$value."\n";
			 }
	  		 $f = fopen ($this->file, "w");   
	  		 for ($k=0;$k<sizeof($str_file);$k++){
	  			fwrite ($f,$str_file[$k]); 
	  		 }
	  		 fclose ($f);
	  	}else{
	  		return false;
		} 

		 
		$this->resetinifile(); 
		return true;
	}
	
/*****************************************************
* Method : Supprime un cl/valeur dans une section
*@param : string $sectionname Nom de la section
*@param : string $key Nom de la cl a enlever
*@return: boolean Si la section est introuvable renvoit false, sinon true
*******************************************************/
	function drop_key($sectionname,$key){
		$filesize = filesize ($this->file);	
		$fd = fopen ($this->file, "r");
		$i = 1;
		 while (!feof ($fd)) {
		 	$tmp_str = fgets($fd, 4096);
		 	if(ereg("\[".$sectionname."\]",$tmp_str)){
		 		$seek = $i;	
		 	}
		 	if($seek && ereg($key."[ ]*=[ ]*",$tmp_str) && !$keyseek){
		 		$keyseek = $i;	
		 	} 		 	
		 	$str_file []= $tmp_str; 
		 	$i++;
		 }
		 fclose($fd);
		 if($seek){
	  		 $f = fopen ($this->file, "w");   
	  		 for ($k=0;$k<sizeof($str_file);$k++){
	  			if($k != $keyseek-1) fwrite ($f,$str_file[$k]); 
	  		 }
	  		 fclose ($f);
	  	 }else{
	  		return false;
		 } 

		 
		$this->resetinifile(); 
		return true;
	}	

/*****************************************************
* Method : Edite une valeur de cl dans une section
*@param : string $sectionname Nom de la section
*@param : string $key Nom de la cl a editer
*@param : string $value Nouvelle valeur
*@param : string $type Type de valeur Default string
*@return: boolean Si la section est introuvable renvoit false, sinon true
*******************************************************/
	function set_key($sectionname,$key,$value,$type="string"){
		if($this->drop_key($sectionname,$key)){
			if($this->add_key($sectionname,$key,$value,$type)){
				$this->resetinifile();	
				return true;
			}
		}	
		return false;
	}
}
?>