<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
/**
* Bibliotheque de fonctions PHP gnriques
*
* Fichier include
*
* @package MyRemoteSql
* @author MyRemoteSql
*/

/**
* Fonction chargeListeFromFic : charge une liste Html  partir d'un fichier texte
* 
* charge une liste Html  partir d'un fichier texte et envoi la syntaxe HTML
* 
* @param string Nom du fichier
* @param string Attributs HTML
* @param array ou tableau contenant valeur(s)  prselectionne(s)
*
* @return string Syntaxe HTML ou false
*/
function chargeListeFromFic($pFichier,$pHtmlAttrib,$pArraySelect)
{
	global $txtLang;
	
	$fp = @fopen($pFichier,"r");
	if ( ! $fp)
	{
		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errfichierouv'] . " " . $pFichier," chargeListeFromFic","1");
		return false;
	}
	
	$txtHtml = $pHtmlAttrib . "\n";

	// Parcourt du fichier
	while ( ! feof( $fp ) )
	{
		$tmp = fgetss( $fp, 1024 );
		if (strlen(trim($tmp)) == 0)
		{
			continue;
		}
		$arrayTmp = explode(";",$tmp);
		
		if (is_array($pArraySelect)) 	// Une tableau string
		{	
			$trouve = false;
			// parcourt du tableau
			for ($i = 0;$i < count($pArraySelect);$i++)
			{
				if (trim($pArraySelect[$i]) == trim($tmp))
				{
					$trouve = true;
					break;	
				}
			}
			if ($trouve)
			{
				$txtHtml .= "<option selected=\"selected\" value=\"" . htmlentities($tmp) . "\">" . htmlentities($arrayTmp[0]) . "</option>\n";
			}
			else
			{
				$txtHtml .= "<option value=\"" . htmlentities($tmp)."\">" . htmlentities($arrayTmp[0]) . "</option>\n";
			}
		}
		else				 	// Une variable string
		{
			if (trim($pArraySelect) == trim($tmp))
			{
			 	$txtHtml .= "<option selected=\"selected\" value=\"" . htmlentities($tmp) . "\">" . htmlentities($arrayTmp[0]) . "</option>\n";
			}
			else
			{
				$txtHtml .= "<option value=\"" . htmlentities($tmp) . "\">" . htmlentities($arrayTmp[0]) . "</option>\n";
			}
		}
	}
 	fclose($fp);
	$txtHtml .= "</select>\n";
	
	return $txtHtml;
}

/**
* Fonction chargeTexteAreaFromFic : charge une liste Html  partir d'un fichier texte
* 
* charge un TexteArea Html  partir d'un fichier texte et envoi la syntaxe HTML
* 
* @param string Nom du fichier
* @param string Attributs HTML
*
* @return string Syntaxe HTML ou false
*/
function chargeTextAreaFromFic($pfichier,$pHtmlAttrib)
{
	global $txtLang;
	
	$fp = @fopen($pfichier,"r" );
	if ( ! $fp)
	{
		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errfichierouv'] . " " . $pfichier," chargeTextAreaFromFic","1");
		return false;
	}

	$txtHtml = $pHtmlAttrib . "\n";
	
	while ( ! feof( $fp ) )
	{
		$tmp = fgetss( $fp, 1024 );
		if (strlen(trim($tmp)) == 0)
		{
			continue;
		}
		$txtHtml .= $tmp;
	}

 	fclose( $fp );
	
	$txtHtml .= "</textarea>\n";
	
	return $txtHtml;
}

/**
* Fonction chargeArrayFromFic : charge un tableau  partir d'un fichier texte
* 
* charge un Tableau  partir d'un fichier texte
* 
* @param string Nom du fichier
*
* @return array le tableau ou false
*/
function chargeArrayFromFic($pfichier)
{
	global $txtLang;
	
	// ouverture Fichier
	$fp = @fopen($pfichier,"r" );
	if ( ! $fp)
	{
		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errfichierouv'] . " " . $pfichier," chargeArrayFromFic","1");
		return false;
	}
	// Lecture des infos
	while ( ! feof( $fp ) )
	{
		$tmp = fgetss( $fp, 1024 );
		if (strlen(trim($tmp)) == 0)
		{
			continue;
		}
		$arrayTmp[] = $tmp;
	}

 	fclose( $fp );

	return $arrayTmp;
}

/**
* Fonction chargeListeFromDir : charge une liste Html  partir d'un rpertoire
* 
* charge un Liste Html  partir d'un rpertoire et envoi la syntaxe HTML
* 
* @param string Rpertoire
* @param string Arguments HTML de la liste
* @param array ou string valeur(s)  prselectionnes
*
* @return string Syntaxe HTML ou false
*/

function chargeListeFromDir($pdir,$pHtmlAttrib,$pArraySelect)
{
	global $txtLang;
	
	if ( ! is_dir($pdir))
	{
		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errdirlire'] . " " . $pdir," chargeListeFromDir","1");
		return false;
	}
	$txtHtml = $pHtmlAttrib . "\n";
	
	// ouverture Dossier
	$dir = opendir($pdir);
	if ( ! $dir)
	{
		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errdirlire'] . " " . $pdir," chargeListeFromDir","1");
		return false;
	}

	// lecture des fichiers du dossier
	while ($fic = trim(readdir($dir)))
	{
		if (is_file("$pdir/$fic"))
		{
			if (is_array($pArraySelect)) 	// Une tableau string
			{	
				$trouve = false;
				// parcourt du tableai
				for ($i = 0;$i < count($pArraySelect);$i++)
				{
					if (trim($pArraySelect[$i]) == trim($fic))
					{
						$trouve = true;
						break;	
					}
				}
				if ($trouve)
				{
					$txtHtml .= "<option selected=\"selected\" value=\"" . $fic . "\">" . $fic . "</option>\n";
				}
				else
				{
					$txtHtml .= "<option value=\"" . $fic . "\">" . $fic . "</option>\n";
				}
			}
			else				 	// Une variable string
			{
				if (trim($pArraySelect) == trim($fic))
				{
				 	$txtHtml .= "<option selected=\"selected\" value=\"" . $fic . "\">" . $fic . "</option>\n";
				}
				else
				{
					$txtHtml .= "<option value=\"" . $fic . "\">" . $fic . "</option>\n";
				}
			}
		}
	}
 	closedir($dir);
	$txtHtml .= "</select>\n";
	
	return $txtHtml;
}

/**
* Fonction chargeListeFromArray : charge une liste HTML  partir d'un tableau
* 
* charge un Liste Html  partir d'un tableau et envoi la syntaxe HTML
* Le tableau [X][0] = clef     [X][1] = libell
* 
* @param string Tableau
* @param string Attributs HTML
* @param string Tableau ou chaine : item(s)  slectionn(s)
*
* @return string Syntaxe HTML ou vide
*/	
function chargeListeFromArray($pArray,$pHtmlAttrib,$pArraySelect)
{
	if (count($pArray) == 0)
	{
		return "";
	}

	$txtHtml = $pHtmlAttrib . "\n";
	// parcourt du tableau
	for ($i = 0;$i < count($pArray);$i++)
	{
		if (is_array($pArraySelect)) 	// Un tableau string
		{	
			$trouve = false;
			// parcourt du tableau
			for ($j=0;$j < count($pArraySelect);$j++)
			{
				if (trim($pArraySelect[$j]) == trim($pArray[$i]))
				{
					$trouve = true;
					break;	
				}
			}
			if ($trouve)
			{
				$txtHtml .= "<option selected=\"selected\" value=\"" . $pArray[$i][0] . "\">" . $pArray[$i][1] . "</option>\n";
			}
			else
			{
				$txtHtml .= "<option value=\"" . $pArray[$i][0] . "\">" . $pArray[$i][1] . "</option>\n";
			}
		}
		else				 	// Une variable string
		{
			if (trim($pArraySelect) == trim($pArray[$i]))
			{
			 	$txtHtml .= "<option selected=\"selected\" value=\"" . $pArray[$i][0] . "\">" . $pArray[$i][1] . "</option>\n";
			}
			else
			{
				$txtHtml .= "<option value=\"" . $pArray[$i][0] . "\">" . $pArray[$i][1] . "</option>\n";
			}
		}
	}

	$txtHtml .= "</select>\n";
	
	return $txtHtml;
}

/**
* Fonction chargeArrayFromDir : charge un tableau  partir d'un rpertoire
* 
* charge un tableau  partir d'un rpertoire
* 
* @param string Rpertoire
*
* @return array tableau ou false
*/	
function chargeArrayFromDir($pdir)
{
	global $txtLang;
	
	if ( ! is_dir($pdir))
	{
		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errdirlire'] . " " . $pdir," chargeListeFromDir","1");
		return false;
	}
		
	$dir = opendir($pdir);
	$i = 0;
	
	while ($fic = readdir($dir))
	{
		if (is_file("$pdir/$fic"))
		{
			$fichier = "$pdir/$fic";
			$tailleFic = filesize($fichier);
			$dateModif = filemtime($fichier);
			$arrayDir[$i][0] = $fichier;
			$arrayDir[$i][1] = $tailleFic;
			$arrayDir[$i][2] = date(LNGDATEHM,$dateModif);
			$i++;
		}
	}
 	closedir($dir);
	
	return $arrayDir;
}

/**
* Fonction printArray : Renvoi un texte Html contenant les lignes d'array
* 
*
* @param array Tableau
*
* @return string texte Html
*/	
function printArray($pArray)
{
	$lgArray = count($pArray);
	
	for ($i = 0; $i<$lgArray; $i++)
	{
		$txtHtml = $txtHtml . $pArray[$i] ."<br />\n";	
		
	}
	return $txtHtml;
}

/**
* Fonction ecritFichier : Ecrit des donnes dans un fichier texte
* 
*  
* @param string Nom du fichier
* @param string les donne  crire
* @param string Mode : (A)jout
* @return booleen
*/	
function ecritFichier($pNomfic,$pData,$pMode)
{
	global $txtLang;
	
	$pData = $pData.chr(13).chr(10);
	
	if ( ! isset($pMode))
	{
		$pMode = "a";
	}

	$fp = @fopen($pNomfic, $pMode);

	if ( ! $fp)
	{
		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errfichierouv'] . " " . $pNomfic," ecritFichier","1");
		return false;
	}
	
	fwrite($fp,$pData);
	
	fclose($fp);
	return true;
}
/**
* Fonction getArrayDiff : Diffrence de 2 tableaux
* 
*  php array_diff ?
*
* @param array Tableau 1
* @param array Tableau 2
* @return array contenant la diffrence
*/	
function getArrayDiff($pa1,$pa2)
{
	$trouve = false;
	
	for ($i = 0;$i < count($pa1);$i++)
	{
		$trouve = false;
		for ($j = 0;$j < count($pa2); $j++)
		{
			if ( trim($pa1[$i]) == trim($pa2[$j]))
			{
				$trouve = true;
				break;
			}
		}
		if (! $trouve)
		{
			$tmparray[] = $pa1[$i];
		}
	}
	return $tmparray;
}

/**
* Fonction getArrayInterSect : intersection de 2 tableaux
* 
*  php array_intersect ?
*
* @param array Tableau 1
* @param array Tableau 2
* @return array contenant l'intersection
*/	
function getArrayInterSect($pa1,$pa2)
{
	$trouve = false;
	
	for ($i = 0;$i < count($pa1);$i++)
	{
		$trouve = false;
		for ($j = 0;$j < count($pa2); $j++)
		{
			if (trim($pa1[$i]) == trim($pa2[$j]))
			{
				$trouve = true;
				break;
			}
		}
		if ($trouve)
		{
			$tmparray[] = $pa1[$i];
		}
	}
	return $tmparray;
}

/**
* Fonction unhtmlentities : renvoi le caractre  partir de l'entit HTML
*  
* @param string chaine html
*
* @return string chaine convertie
*/	
function unhtmlentities($pChaineHtml)
{
	$tmp = get_html_translation_table(HTML_ENTITIES);
	$tmp = array_flip($tmp);
	$chaineTmp = strtr($pChaineHtml,$tmp);

	return $chaineTmp;
}

/**
* Fonction getFicContenu
*  
* @param string Fichier
*
* @return string chaine contenant le contenu ou fide
*/	
function getFicContenu($pFic)
{
	global $txtLang;
	
	if( ! is_readable($pFic))
	{
		return "";
	}
	$fp = @fopen($pFic, "r");
	if ( ! $fp)
	{
		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errfichierouv'] . " " . $pFic," getFicContenu","1");
		return "";
	}
	$dataFic = fread($fp,filesize($pFic));
	fclose($fp);
	
	return $dataFic;
}
?>