<?php
/**
* Classe de conversion des rsultats
*
*
* @package MyRemoteSql
* @author MyRemoteSql
*/
class convertion
{
	var $typeSortie = "HTML";
	var $preSortie  = "S-SQL";
	var $skinHtml 	= "";

	//////////////////////////// Convertion et Traitement du rsultat ////////////////////////////////////////
	/**
	* Fonction convertResult
	*
	* Fonction Aiguillage sur la convertion en fonction de la sortie
	* Renvoi un tableau de valeurs au format slectionn (Xml, Html ...)
	*
	* @param array tableau de valeurs issues de executeMySql
	*
	* @return array
	*/
	function convertResult($pArrayData)
	{
		if (strtoupper(trim($this->preSortie)) == "S-SQL")
		{
			switch (strtoupper(trim($this->typeSortie)))
			{
				case "TEXTE":
					return $this->resultToTexte($pArrayData);
					break;
				
				case "CSV":
					return $this->resultToTexte($pArrayData);
					break;
				
				case "HTML":
					return $this->resultToHtml($pArrayData);
					break;
					
				case "XML":
					return $this->resultToXml($pArrayData);
					break;
					
				case "PDF":
					return $this->resultToPdf($pArrayData);
					break;
					
				default:
					return $this->resultToTexte($pArrayData);
					break;
			}
		}
		else
		{
			switch (strtoupper(trim($this->typeSortie)))
			{
				case "TEXTE":
					return $this->resultToTexte2($pArrayData);
					break;
				
				case "CSV":
					return $this->resultToTexte2($pArrayData);
					break;
				
				case "HTML":
					return $this->resultToHtml2($pArrayData);
					break;
					
				case "XML":
					return $this->resultToXml($pArrayData);
					break;
					
				case "PDF":
					return $this->resultToPdf($pArrayData);
					break;
					
				default:
					return $this->resultToTexte($pArrayData);
					break;
			}
		}
	}
	
	/**
	* Fonction resultToHtml : renvoi un tableau de valeurs au format HTML
	*
	* Convertit un tableau de valeurs au format HTML
	*
	* @param array tableau de valeurs
	*
	* @return array
	*/
	function resultToHtml($parrayRes)
	{
		global $txtLang;
		$enregistrementPair = true;
		$skinHtml = $this->skinHtml;
		
		$arrayHtml[] = ENTETEHTML;
		$arrayHtml[] = getCommentaireSortie();
		$arrayHtml[] = "<head>";
		$arrayHtml[] = "<title>";
		$arrayHtml[] = "MyRemoteSQL " . MYREMOTESQL_VERSION . " - " . $txtLang['resultats'];
		$arrayHtml[] = "</title>";
		$arrayHtml[] = selectSkinHtml($skinHtml);
		$arrayHtml[] = "</head>";
		$arrayHtml[] = "<body>";
		
		$lgArray = count($parrayRes);
		
		// Parcourt du tableau pour traitement			
		for ($i=0 ; $i < $lgArray ; $i++)
		{
			$code = substr($parrayRes[$i],0,MRSLGCODE);
			$commentaire = substr($parrayRes[$i],MRSLGCODE,strlen($parrayRes[$i]) - MRSLGCODE);
			
			$code = trim(htmlentities($code));
			$commentaire = trim(htmlentities(unhtmlentities($commentaire)));
			
			// Entete
			if ($code == "H")
			{
				$arrayHtml[] = "<span id=\"entete$i\" class=\"spanresentete\">$commentaire</span><br />";
			}
			// Entete perso
			if ($code == "PERSO")
			{
				$arrayHtml[] = "<span id=\"perso\" class=\"spanresentete\">$commentaire</span><br />";
			}
			// Erreur
			if ($code == "E")
			{
				$arrayHtml[] = "<span id=\"erreur$i\" class=\"spanreserreur\">$commentaire</span><br />";
			}
			// Erreur Connexion
			if ($code == "CNXERR")
			{
				$arrayHtml[] = "<span id=\"erreur$i\" class=\"spanreserreur\">$commentaire</span><br />";
			}
			// Informations
			if ($code == "I")
			{
				$arrayHtml[] = "<span id=\"info$i\" class=\"spanresinfo\">$commentaire</span><br />";
			}
					
			// Dbut session serveur
			if ($code == "S")
			{
				$arrayHtml[] = "<br /><div id=\"serveur$i\" class=\"divresserveur\">";
			}
			
			// Fin session serveur
			if ($code == "SF")
			{
				$arrayHtml[] = "</div><br />";
			}
			
			// Dbut Requete
			if ($code == "R")
			{
				//$arrayHtml[] = "<table class=\"tblres\" border=\"1\" >";
				$arrayHtml[] = "<table class=\"tblres\">";
			}
			
			// Informations Requete
			if ($code == "REQNBR")
			{
				$arrayHtml[] = "<caption id=\"info$i\" class=\"spanresinfo\">$commentaire" . $txtLang['enregistmaj'] . "</caption>";
			}
					
			// Fin Requete
			if ($code == "RF")
			{
				$arrayHtml[] = "</table>";
			}
			
			// Nom de champs
			if ($code == "C")
			{
				$nomChamps = explode(SEPARATEUR,$commentaire);
										
				$nbChamps = count($nomChamps);
				
				$arrayHtml[] = "<tr class=\"trnomchamps\">";
				
				for ($j=0; $j < $nbChamps; $j++)
				{
					
					$arrayHtml[] = "<td class=\"tdnomchamps\">$nomChamps[$j]</td>";
				}
				
				$arrayHtml[] = "</tr>";
			}
			
			// Champs
			if ($code == "D")
			{
				$champs = explode(SEPARATEUR,$commentaire);
				
				$nbChamps = count($champs);
				
				$arrayHtml[] = "<tr class=\"trchamps\">";
				
				for($j=0; $j < $nbChamps; $j++)
				{
					// Champ Vide ?
					if (trim($champs[$j]) == "")
					{
						$champs[$j] = "&nbsp";
					}
					// Gestion des lignes paires / impaires pour Style
					if ($enregistrementPair)
					{
						$arrayHtml[] = "<td class=\"tdpair\">$champs[$j]</td>";
					}
					else
					{
						$arrayHtml[] = "<td class=\"tdimpair\">$champs[$j]</td>";
					}
				}
				
				$arrayHtml[] = "</tr>";
				// Gestion des lignes paires / impaires pour Style
				if ($enregistrementPair)
				{
					$enregistrementPair = false;
				}
				else
				{
					$enregistrementPair = true;
				}
			// Fin code champs
			}
			
			// Comparaison de base
			
			if ($code == "TBL")
			{
				$arrayHtml[] = $commentaire . "<br />";
			}

			if ($code == "TR")
			{
				$arrayHtml[] = "<div class=\"divtablesref\">";
			}
			
			if ($code == "TRF")
			{
				$arrayHtml[] = "</div>";
			}
		
			if ($code == "TB")
			{
				$arrayHtml[] = "<div class=\"divtablesbase\">";
			}
			
			if ($code == "TBF")
			{
				$arrayHtml[] = "</div>";
			}
							
			if ($code == "TC")
			{
				$arrayHtml[] = "<div class=\"divtablescommunes\">";
			}
			
			if ($code == "TCF")
			{
				$arrayHtml[] = "</div>";
			}
			
			if ($code == "T+")
			{
				$arrayHtml[] = "<div class=\"divtablessup\">";;
			}
			
			if ($code == "T+F")
			{
				$arrayHtml[] = "</div>";
			}
			
			if ($code == "T-")
			{
				$arrayHtml[] = "<div class=\"divtablesmoins\">";;
			}
			
			if ($code == "T-F")
			{
				$arrayHtml[] = "</div>";
			}
			
			if ($code == "FLD")
			{
				$arrayHtml[] = $commentaire. "<br />";
			}
			
			if ($code == "TY")
			{
				$arrayHtml[] = "<div class=\"divtables\">";;
				$arrayHtml[] = $commentaire. "<br />";
			}
			
			if ($code == "TYF")
			{
				$arrayHtml[] = "</div>";
			}
			/*
			if ($code == "C+")
			{
				$arrayHtml[] = "<champplus>";
			}
			
			if ($code == "C+F")
			{
				$arrayHtml[] = "</champplus>";
			}
			
			if ($code == "C-")
			{
				$arrayHtml[] = "<champmoins>";
			}
			
			if ($code == "C-F")
			{
				$arrayHtml[] = "</champmoins>";
			}
			*/
			
		// fin de boucle	
		}
		
		// Fin de traitement
		$arrayHtml[] = "</body>";
		$arrayHtml[] = "</html>";

		return $arrayHtml;
	}
	/**
	* Fonction resultToXml : renvoi un tableau de valeurs au format XML
	*
	* Convertit un tableau de valeurs au format XML
	*
	* @param array tableau de valeurs
	*
	* @return array
	*/
	function resultToXml($parrayRes)
	{
		$arrayXml[] = ENTETEXML;
		$arrayXml[] = getCommentaireSortie();
		
		// URL CSS ou XSL
		$url= getXmlXslCss();
		if ($url != "")
		{
			$arrayXml[] = "<?xml-stylesheet type=\"text/xsl\" href=\"". $url . "\"?>";
		}
		
		$arrayXml[] = "<document>";
		
		$lgArray = count($parrayRes);
		
		// Parcourt du tableau pour traitement			
		for ($i=0 ; $i < $lgArray ; $i++)
		{
			$code = trim(substr($parrayRes[$i],0,MRSLGCODE));
			$commentaire = substr($parrayRes[$i],MRSLGCODE,strlen($parrayRes[$i]) - MRSLGCODE);
			$commentaire = trim(unhtmlentities($commentaire));
			
			// Entete
			if ($code == "H")
			{
				$arrayXml[] = "<entete>$commentaire</entete>";
			}
			// Entete perso
			if ($code == "PERSO")
			{
				$arrayXml[] = "<perso>$commentaire</perso>";
			}
			// Erreur
			if ($code == "E")
			{
				$arrayXml[] = "<erreur>$commentaire</erreur>";
			}
			// Informations
			if ($code == "I")
			{
				$arrayXml[] = "<info>$commentaire</info>";
			}
			// Dbut session serveur
			if ($code == "S")
			{
				$arrayXml[] = "<serveur>";
			}
			
			// Dbut Connexion
			if ($code == "CNX")
			{
				$arrayXml[] = "<connexion>";
			}
			// Connexion
			if ($code == "CNXIP")
			{
				$arrayXml[] = "<ip>".$commentaire."</ip>";
			}
			// Connexion
			if ($code == "CNXPOR")
			{
				$arrayXml[] = "<port>".$commentaire."</port>";
			}
			// Connexion
			if ($code == "CNXDAT")
			{
				$arrayXml[] = "<date>".$commentaire."</date>";
			}
			// Connexion
			if ($code == "CNXDB")
			{
				$arrayXml[] = "<base>".$commentaire."</base>";
			}
			// Connexion
			if ($code == "CNXUSR")
			{
				$arrayXml[] = "<usr>".$commentaire."</usr>";
			}
			// Erreur Connexion
			if ($code == "CNXERR")
			{
				$arrayXml[] = "<cnxerreur>$commentaire</cnxerreur>";
			}
			// Fin Connexion
			if ($code == "CNXFIN")
			{
				$arrayXml[] = "</connexion>";
			}
			
			// Dbut Requete
			if ($code == "R")
			{
				$arrayXml[] = "<requete>";
				unset($nomChamps);
			}
			// Nombre enregistrements
			if ($code == "REQNBR")
			{
				$arrayXml[] = "<sqlrecords>".$commentaire."</sqlrecords>";;
			}
			if ($code == "REQERR")
			{
				$arrayXml[] = "<sqlerreur>".$commentaire."</sqlerreur>";;
			}
			if ($code == "REQTXT")
			{
				$arrayXml[] = "<sqltexte>".$commentaire."</sqltexte>";;
			}
			// Fin Requete
			if ($code == "RF")
			{
				$arrayXml[] = "</requete>";
			}
			
			// Fin session serveur
			if ($code == "SF")
			{
				$arrayXml[] = "</serveur>";
			}
			
			// Nom de champs
			if ($code == "C")
			{
				$nomChamps = explode(SEPARATEUR,$commentaire);
										
				$nbChamps = count($nomChamps);
				for($j=0; $j < $nbChamps; $j++)
				{
					$arrayXml[] = "<champ>$nomChamps[$j]</champ>";
				}
			}
			
			// Champs
			if ($code == "D")
			{
				unset($champs);
				$champs = explode(SEPARATEUR,$commentaire);
				
				$nbChamps = count($champs);
				for($j=0; $j < $nbChamps; $j++)
				{
					if (trim($champs[$j]) == "")
					{
						continue;
					}
					$arrayXml[] = "<$nomChamps[$j]>$champs[$j]</$nomChamps[$j]>";
				}
			}
			
			// Pour Comparaison de bases
			if ($code == "TBL")
			{
				$arrayXml[] = "<table>".$commentaire."</table>";
			}
			
			if ($code == "TR")
			{
				$arrayXml[] = "<tablesref>";
			}
			
			if ($code == "TRF")
			{
				$arrayXml[] = "</tablesref>";
			}
			
			if ($code == "TB")
			{
				$arrayXml[] = "<tablesbase>";
			}
			
			if ($code == "TBF")
			{
				$arrayXml[] = "</tablesbase>";
			}
			
			if ($code == "TC")
			{
				$arrayXml[] = "<tablescommunes>";
			}
			
			if ($code == "TCF")
			{
				$arrayXml[] = "</tablescommunes>";
			}
			
			if ($code == "T+")
			{
				$arrayXml[] = "<tablessup>";
			}
			
			if ($code == "T+F")
			{
				$arrayXml[] = "</tablessup>";
			}
			
			if ($code == "T-")
			{
				$arrayXml[] = "<tablesmoins>";
			}
			
			if ($code == "T-F")
			{
				$arrayXml[] = "</tablesmoins>";
			}
			
			if ($code == "FLD")
			{
				$arrayXml[] = "<champ>".$commentaire."</champ>";
			}
			
			if ($code == "TY")
			{
				$arrayXml[] = "<$commentaire>";
			}
			
			if ($code == "TYF")
			{
				$arrayXml[] = "</$commentaire>";
			}
			
			if ($code == "C+")
			{
				$arrayXml[] = "<champplus>";
			}
			
			if ($code == "C+F")
			{
				$arrayXml[] = "</champplus>";
			}
			
			if ($code == "C-")
			{
				$arrayXml[] = "<champmoins>";
			}
			
			if ($code == "C-F")
			{
				$arrayXml[] = "</champmoins>";
			}
		// Fin boucle sur tableau
		}
		
		// Fin de traitement
		$arrayXml[] = "</document>";
		
		return $arrayXml;
	}
	/**
	* Fonction resultTotexte : renvoi un tableau de valeurs au format Texte
	*
	* Convertit un tableau de valeurs au format Texte ou CSV
	*
	* @param array tableau de valeurs
	*
	* @return array
	*/
	function resultToTexte($parrayRes)
	{
	
		// dfinition du sparateur pour fichier texte
		switch (strtoupper(trim($this->typeSortie)))
		{
			case "TEXTE":
				$separateur = "\t";
				break;
			
			case "CSV":
				$separateur = ";";
				break;
		
			default:
				$separateur = "\t";
				break;
		}
		
		// Mise en forme du tableau	avec le bon sparateur
		$lgArray = count($parrayRes);
						
		for($i=0; $i < $lgArray; $i++)
		{
			$code = substr($parrayRes[$i],0,MRSLGCODE);
			$commentaire = unhtmlentities(substr($parrayRes[$i],MRSLGCODE,strlen($parrayRes[$i]) - MRSLGCODE));
			
			// mise en forme des champs et nom de champs			
			if (strpos($commentaire,SEPARATEUR))
			{
				$commentaire = str_replace(SEPARATEUR,$separateur,$commentaire) ;
			}

			$arrayTxt[$i] = $code . $separateur . $commentaire;
			
		}
		return $arrayTxt;
	}
	
	/**
	* Fonction resultToPdf : renvoi un tableau de valeurs au format Pdf
	*
	* Convertit un tableau de valeurs au format Pdf
	*
	* @param array tableau de valeurs
	*
	* @return array
	*/
	function resultToPdf($parrayRes)
	{
	define('FPDF_FONTPATH','font/');
	require('fpdf.php');
	
	$pdf=new FPDF();
	$pdf->SetAutoPageBreak(true) ;
	$pdf->AddPage();
	$pdf->SetFont('Arial','',8);
	$pdf->write(5,getCommentaireSortie());
	$pdf->SetCreator("MyRemotesql") ;
	$pdf->SetTitle(getCommentaireSortie()) ;
	$pdf->ln();
	
	$lgArray = count($parrayRes);
		
	// Parcourt du tableau pour traitement			
	for ($i=0 ; $i < $lgArray ; $i++)
	{
		$code = trim(substr($parrayRes[$i],0,MRSLGCODE));
		$commentaire = trim(substr($parrayRes[$i],MRSLGCODE,strlen($parrayRes[$i]) - MRSLGCODE));
		
		//$code = $code;
		//$commentaire =$commentaire;
		
		// Entete
		if ($code == "H")
		{
			$pdf->SetFont('Arial','',10);
			$pdf->write(5,$commentaire);
			$pdf->ln();
			$pdf->SetFont('Arial','',8);
		} 
	
		// Erreur
		if ($code == "E")
		{
			$pdf->SetFont('Arial','B',10);
			$pdf->write(5,$commentaire);
			$pdf->ln();
			$pdf->SetFont('Arial','',8);
		}
		// Informations
		if ($code == "I")
		{
			$pdf->SetFont('Arial','',8);
			$pdf->write(5,$commentaire);
			$pdf->ln();
			$pdf->SetFont('Arial','',8);
		}
		
		if ($code == "C")
		{
			$pdf->SetFont('Arial','',8);
			$pdf->write(5,$commentaire);
			$pdf->ln();
			$pdf->SetFont('Arial','',8);
		}
		
		if ($code == "D")
		{
			$pdf->SetFont('Arial','',8);
			$pdf->write(5,$commentaire);
			$pdf->ln();
			$pdf->SetFont('Arial','',8);
		}
	
		
		// Dbut session serveur
			if ($code == "S")
			{
				$pdf->SetFont('Arial','',8);
				$pdf->write(5,$commentaire);
				$pdf->ln();
				$pdf->SetFont('Arial','',8);
			}
			
			// Fin sessionn serveur
			if ($code == "SF")
			{
				$pdf->SetFont('Arial','',8);
				$pdf->write(5,$commentaire);
				$pdf->ln();
				$pdf->SetFont('Arial','',8);

			}
			
			// Dbut Requete
			if ($code == "R")
			{
				$pdf->SetFont('Arial','',8);
				$pdf->write(5,$commentaire);
				$pdf->ln();
				$pdf->SetFont('Arial','',8);

			}
			
	// Fin de boucle	
	}
	
	$arrayRes[0]= $pdf->Output("Fic","S");
	
	return $arrayRes;
	}
	
	/**
	* Fonction resultToHtml2 : renvoi un tableau de valeurs au format HTML
	*
	* Convertit un tableau de valeurs au format HTML
	*
	* @param array tableau de valeurs
	*
	* @return array
	*/
	function resultToHtml2($parrayRes)
	{
		global $txtLang;
		$enregistrementPair = true;
		$afficheEntete = true;
		$serveurCourant = "";
		
		$skinHtml = $this->skinHtml;
		
		$arrayHtml[] = ENTETEHTML;
		$arrayHtml[] = getCommentaireSortie();
		$arrayHtml[] = "<head>";
		$arrayHtml[] = "<title>";
		$arrayHtml[] = "MyRemoteSQL " . MYREMOTESQL_VERSION . " - " . $txtLang['resultats'];
		$arrayHtml[] = "</title>";
		$arrayHtml[] = selectSkinHtml($skinHtml);
		$arrayHtml[] = "</head>";
		$arrayHtml[] = "<body>";
		
		$lgArray = count($parrayRes);
			
		// Parcourt du tableau pour traitement			
		for ($i=0 ; $i < $lgArray ; $i++)
		{
									
			$code = substr($parrayRes[$i],0,MRSLGCODE);
			$commentaire = substr($parrayRes[$i],MRSLGCODE,strlen($parrayRes[$i]) - MRSLGCODE);
			
			$code = trim(htmlentities($code));
			$commentaire = trim(htmlentities(unhtmlentities($commentaire)));
			
			// Entete
			if ($code == "H")
			{
				$arrayHtml[] = "<span id=\"entete$i\" class=\"spanresentete\">$commentaire</span><br />";
			}
			// Entete perso
			if ($code == "PERSO")
			{
				$arrayHtml[] = "<span id=\"perso\" class=\"spanresentete\">$commentaire</span><br />";
			}
			if ($code == "F")
			{
				$arrayHtml[] = "<span id=\"fin$i\" class=\"spanresfin\">$commentaire</span><br />";
			}
		
			// Erreur
			if ($code == "E")
			{
				$arrayHtml[] = "<span id=\"erreur$i\" class=\"spanreserreur\">$commentaire</span><br />";
			}
			// Erreur
			if ($code == "CNXERR")
			{
				$arrayHtml[] = "<span id=\"erreur$i\" class=\"spanreserreur\">$commentaire</span><br />";
			}
			// Id serveur
			if ($code == "IDS")
			{
				$serveurCourant = $commentaire;
			}
			
			// Dbut Requete
			if ($code == "R")
			{
				$arrayHtml[] = "<table class=\"tblres\"  >";
				$afficheEntete = true;
			}
			
			// Informations Requete
			if ($code == "REQNBR")
			{
				$arrayHtml[] = "<caption id=\"info$i\" class=\"spanresinfo\">$commentaire" . $txtLang['enregistmaj'] . "</caption>";
			}
			
			// Fin Requete
			if ($code == "RF")
			{
				$arrayHtml[] = "</table><br />";
				$afficheEntete = true;
			}
			
			// Nom de champs
			if (($code == "C") and ($afficheEntete))
			{
				$nomChamps = explode(SEPARATEUR,"Serveur".SEPARATEUR.$commentaire);
										
				$nbChamps = count($nomChamps);
				
				$arrayHtml[] = "<tr class=\"trnomchamps\">";
				
				for ($j=0; $j < $nbChamps; $j++)
				{
					
					$arrayHtml[] = "<td class=\"tdnomchamps\">$nomChamps[$j]</td>";
				}
				
				$arrayHtml[] = "</tr>";
				
				$afficheEntete = false;
			}
			
			// Champs
			if ($code == "D")
			{
				$champs = explode(SEPARATEUR,$serveurCourant.SEPARATEUR.$commentaire);
				
				$nbChamps = count($champs);
				
				$arrayHtml[] = "<tr class=\"trchamps\">";
				
				for($j=0; $j < $nbChamps; $j++)
				{
					// Champ Vide ?
					if (trim($champs[$j]) == "")
					{
						$champs[$j] = "&nbsp";
					}
					// Gestion des lignes paires / impaires pour Style
					if ($enregistrementPair)
					{
						$arrayHtml[] = "<td class=\"tdpair\">$champs[$j]</td>";
					}
					else
					{
						$arrayHtml[] = "<td class=\"tdimpair\">$champs[$j]</td>";
					}
				}
				
				$arrayHtml[] = "</tr>";
				// Gestion des lignes paires / impaires pour Style
				if ($enregistrementPair)
				{
					$enregistrementPair = false;
				}
				else
				{
					$enregistrementPair = true;
				}
			// Fin code champs
			}
				
		// fin de boucle	
		}
		
		// Fin de traitement
		$arrayHtml[] = "</body>";
		$arrayHtml[] = "</html>";
		
		return $arrayHtml;
	}
	
	/**
	* Fonction resultTotexte2 : renvoi un tableau de valeurs au format Texte
	*
	* Convertit un tableau de valeurs au format Texte ou CSV
	*
	* @param array tableau de valeurs
	*
	* @return array
	*/
	function resultToTexte2($parrayRes)
	{
	
		// dfinition du sparateur pour fichier texte
		switch (strtoupper(trim($this->typeSortie)))
		{
			case "TEXTE":
				$separateur = "\t";
				break;
			
			case "CSV":
				$separateur = ";";
				break;
		
			default:
				$separateur = "\t";
				break;
		}
		
		$serveurCourant = "";
		$afficheEntete  = true;
		
		// Mise en forme du tableau	avec le bon sparateur
		$lgArray = count($parrayRes);
						
		for ($i = 0; $i < $lgArray; $i++)
		{
			$code = trim(substr($parrayRes[$i],0,MRSLGCODE));
			$commentaire = trim(unhtmlentities(substr($parrayRes[$i],MRSLGCODE,strlen($parrayRes[$i]) - MRSLGCODE)));
			
			// mise en forme des champs et nom de champs			
			if (strpos($commentaire,SEPARATEUR))
			{
				$commentaire = str_replace(SEPARATEUR,$separateur,$commentaire) ;
			}
				
			// Entete
			if ($code == "H")
			{
				$arrayTxt[] = $commentaire;
			}
			
			if ($code == "F")
			{
				$arrayTxt[] = $commentaire;
			}
		
			// Erreur
			if ($code == "E")
			{
				$arrayTxt[] = $commentaire;
			}
			
			// Id serveur
			if ($code == "IDS")
			{
				$serveurCourant = $commentaire;
			}
				
			// Dbut Requete
			if ($code == "R")
			{
				$afficheEntete = true;
			}
			
			// Fin Requete
			if ($code == "RF")
			{
				$afficheEntete = true;
			}
			
			// Nom de champs
			if (($code == "C") and ($afficheEntete))
			{
				$tmpChamps = "";
				$nomChamps = explode($separateur,"Serveur".$separateur.$commentaire);
										
				$nbChamps = count($nomChamps);
											
				for ($j=0; $j < $nbChamps; $j++)
				{
					
					 $tmpChamps .= $nomChamps[$j].$separateur;
				}
				$afficheEntete = false;
				$arrayTxt[] = $tmpChamps;
			}
			
			// Champs
			if ($code == "D")
			{
				$tmpChamps = "";
				$champs = explode($separateur,$serveurCourant.$separateur.$commentaire);
				
				$nbChamps = count($champs);
				
				for($j=0; $j < $nbChamps; $j++)
				{
					// Champ Vide ?
					if (trim($champs[$j]) == "")
					{
						$champs[$j] = " ";
					}
					$tmpChamps .= $champs[$j].$separateur;
				}
				$arrayTxt[] = $tmpChamps;
			// Fin code champs
			}
		// Fin de boucle
		}
		return $arrayTxt;
	}
		
	/**
	* Fonction resultToPrint : Affichage du rsultat  l'cran
	*
	* Affiche le tableau de valeur  l'cran
	*
	* @param array tableau de valeurs
	*
	* @return array
	*/
	function resultToPrint($pArrayData)
	{
		// Affichage Data
		$lgArray = count($pArrayData);
		
		for($i=0; $i < $lgArray; $i++)
		{
			print($pArrayData[$i] . "\n");
		}
		return true;
	}
	/**
	* Fonction resultToFile : Ecriture dans un fichier du tableau de valeurs converties
	*
	* Ecriture dans un fichier du tableau de valeurs converties
	*
	* @param string Nom du fichier
	* @param array tableau de valeurs
	* @param string mode d'criture du fichier Ajout ou nouveau fichier
	*
	* @return booleen
	*/
	function resultToFile($pNomFic,$pArrayPrintData,$pMode)
	{
		// mode d'ouverture
		if ( ! isset($pMode))
		{
			$pMode = "a";
		}
		
		// Ouverture du fichier		
		$fp = @fopen($pNomFic, $pMode);

		if ( ! $fp)
		{
			return false;
		}
				
		// Enregistrement Data
		$lgArray = count($pArrayPrintData);
		
		for($i = 0; $i < $lgArray; $i++)
		{
			$a = $pArrayPrintData[$i];
						
			fwrite($fp,$pArrayPrintData[$i] . "\r\n");
		}
		fclose($fp);
		
		return true;
	}
	
	/**
	* Fonction resultToHTMLData : renvoi un tableau de valeurs au format HTML de data : <table> ...</table>
	*
	* @param array tableau de valeurs
	*
	* @return array
	*/
	function resultToHTMLData($parrayRes)
	{
		$lgArray = count($parrayRes);
		$copie = false;
						
		for ($i = 0; $i < $lgArray; $i++)
		{
			$chaine = trim("*".$parrayRes[$i]);
			$a = strpos($chaine,"<table");
			$b = strpos($chaine,"</table");
			
			if ($a == 1)
			{
				$arrayHtml[] = $parrayRes[$i];
				$copie = true;
				continue;
			}
			
			if ($b == 1)
			{
				$arrayHtml[] = $parrayRes[$i];
				$copie = false;
				continue;
			}
			
			if ($copie) 
			{
				$arrayHtml[] = $parrayRes[$i];
				continue;
			}
		}
		return $arrayHtml;
	}
	
}	
?>