<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
/**
* Bibliothque de fonctions PHP de l'application
*
*
* @package MyRemoteSql
* @author MyRemoteSql
*/

/**
* Fonction verifClauseSql : vrif de la requte SQL
*
* Vrification de la clause SQL : vide, Mots interdits, pas de WHERE ...
*
* @param string La requete SQL
*
* @return string
*/

function verifClauseSql($pSql)
{
	global $txtLang;
	
	$pSql = strtoupper(trim($pSql));
	
	// Clause Sql Vide
	if ($pSql == "")
	{
		return $txtLang['errsqlvide'];
	}
	
	// Chargement des mots clef interdits
	$listeMots = chargeArrayFromFic(FILEDENY);
		
	// Vrification des mots clef
	foreach ($listeMots as $motClef)
	{
		$motClef = trim(strtoupper($motClef));
					
		if (strstr($pSql,$motClef))
		{
			return $txtLang['errmotinterdit'] . " " . $motClef;
		}
	}
	
	// Ctrl de l'Update
	if (strlen(strstr($pSql,"UPDATE")) > 1 )
	{
		if (strstr($pSql,"WHERE") == false)     
		{
			return $txtLang['errUpdateWhere'];
		}
	}

	// Ctrl du Delete
	if (strlen(strstr($pSql,"DELETE")) > 1 )
	{
		if (strstr($pSql,"WHERE") == false)     
		{
			return $txtLang['errDeleteWhere'];
		}
	}
	
	return "";
}
/**
* Fonction selectSkin : utilisation du fichier skin slectionn
*
* Renvoi le texte Html en fonction du skin <link ...
*
* @param string Nom du fichier skin .CSS
*
* @return string
*/
Function selectSkin($pSkin)
{
	$dirSkin = DIRSKIN;
	$txtHtml = "<link rel=\"stylesheet\" href=\"$dirSkin/$pSkin\" type=\"text/css\" />";
		
	return $txtHtml;
}
/**
* Fonction selectSkinHtml: utilisation du fichier skin slectionn pour la sortie HTML
*
* Renvoi le texte Html balise Style en fonction du skin ...
*
* @param string Nom du fichier skin .CSS
*
* @return string
*/
Function selectSkinHtml($pSkin)
{
	if (trim($pSkin) == "")
	{
		return " ";
	}
	
	global $txtLang;
	
	$dirSkin = DIRSKINHTML;
	$htmlText = "<style type=\"text/css\">";
		
	// Ouverture fichier
	$fp = @fopen("$dirSkin/$pSkin","r" );
	if ( ! $fp)
	{
		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errfichierouv'] . " " . $dirSkin/$pSkin," selectSkinHtml","1");
		return false;
	}
	
	while ( ! feof( $fp ) )
	{
		$tmp = fgetss( $fp, 1024 );
		if (strlen(trim($tmp)) == 0)
		{
			continue;
		}
		$htmlText = $htmlText . $tmp;
	}

 	fclose( $fp );
			
	$htmlText = $htmlText . "</style>";
	
	return $htmlText;	
}
/**
* Fonction afficheMenu : Affiche le menu de l'application  partir d'un array
*
* Renvoi le texte Html du menu lien <a ...
*
* @param array le tableau contenant les lments de menu
*
* @return string
*/
function afficheMenu($pArray)
{
	// Affichage des liens
	for($i=0;$i< count($pArray);$i++)
	{
		$element = explode(";",$pArray[$i]);
		$element[0] = htmlentities($element[0]);
		$element[1] = htmlentities($element[1]);
		
		$htmlText .= "<a href=\"" . $element[0] . "\" accesskey=\"" .  $element[2] . "\" class=\"menu\" id=\"menu$i\">" . $element[1] . "</a><br />\n";
	}
	
	return $htmlText;
}
/**
* Fonction afficheTitre : Affiche le titre de la page courante
*
* Affiche le titre de la page courante et Renvoi le texte Html balise <div ...
*
* @param string le titre  afficher
*
* @return string
*/
Function afficheTitre($pTitre)
{
	$htmlText  = "<div id=\"divtitre\">\n";
	$htmlText .= "<h1>$pTitre</h1>\n";
	$htmlText .= "<span id=\"spantitre\">" . date(LNGDATEC) . "</span>\n";
	$htmlText .= "<span id=\"spantitre2\">" . " ". "</span>\n";
	$htmlText .= "</div>\n";
	
	return $htmlText;
}
/**
* Fonction afficheEntete : Affiche la fin d'entte de la page courante
*
* Affiche la fin d'entte de la page courante et Renvoi le texte Html balise <div ...
*
* @return string
*/
Function afficheEntete()
{
	global $arrMenu;
	
	$htmlText  = "</head>\n";
	$htmlText .= "<body>\n";
	$htmlText .= "<div id=\"divmenu\">\n";
	$htmlText .= "<span id=\"spanmenu\">\n";
	$htmlText .= "Menu\n";
	$htmlText .= "</span>\n";
	$htmlText .= "<br />\n";
	$htmlText .= "<br />\n";

	// Affichage du menu de Lang/...
	$htmlText .= afficheMenu($arrMenu);
	
	//Affichage du menu de Conf/mrsmenu...
	$arr = chargeArrayFromFic(FILEMENU);
	$htmlText .= afficheMenu($arr);

	$htmlText .= "</div>\n";
	
	return $htmlText;
}
/**
* Fonction getCommentaireHtml : renvoi un commentaire HTML/XML avec la date et version
*
*
* @return string
*/
Function getCommentaireSortie()
{
	$dateCourante = date(LNGDATEHM);
	$version = MYREMOTESQL_VERSION;
	
	$htmlText = "<!-- Document produit par MyRemoteSql - Version $version Le $dateCourante -->";	
	
	return $htmlText;
}

/**
* Fonction getSqlFromFichier : Rcupere une requete SQL d'un fichier texte
*
* @param string fichier  lire
*
* @return string
*/
function getSqlFromFichier($pFichier)
{
	global $txtLang;
	
	if (trim($pFichier) == "")
	{
		return "";
	}
	
	$dataFic = "";
	if ($pFichier != "none") 
	{   
    	if (file_exists($pFichier)) 
    	{  
	    	$fp = @fopen($pFichier, "r");
	    	if ( ! $fp)
			{
	    		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errfichierouv'] . " " . $pFichier," getSqlFromFichier","1");
				return false;
			}
	       	$dataFic = fread($fp,filesize($pFichier));  
        	if (get_magic_quotes_runtime() == 1)
        	{                           
            	$dataFic = stripslashes($dataFic);  
            }
            fclose($fp);   
    	}                                                                    
	}        	
	return $dataFic;
}
/**
* Fonction afficheServeurs : Renvoi un texte Html pour Affichage de la liste des serveurs
*
* Renvoi le texte Html
* @param string Attributs Html pour cration liste
* @return string
*/
function afficheServeurs($pHtmlAttrib)
{
	$arrayTmp = array();
	$arrayTmp2 = array();
	$arrayListServeurs = array();
	
	// Chargement du fichiers des serveurs
	$arrayListServeurs = chargeArrayFromFic(FILESERVEUR);
	
	// Transfo : extraction du No serveur + dnomination
	for($i=0;$i<count($arrayListServeurs);$i++)
	{
		$varStr = $arrayListServeurs[$i];
		$arrayTmp2 = explode(";",$varStr);
		$arrayResult[$i][0] = $arrayTmp2[0];
		$arrayResult[$i][1] = $arrayTmp2[1];
	}
	
	// Constitution de la liste HTML
	$htmlText = chargeListeFromArray($arrayResult,$pHtmlAttrib,"");
	
	return $htmlText;
}
/**
* Fonction getProprieteServeurs : renvoi les proprits d'un serveur : IP,base,user,port ...
*
* @param array tableau de No de serveurs
* @return array 
*/
function getProprieteServeurs($pServ)
{
	$arrayListServeurs = array();
	$arrayResult = array();
		
	$arrayListServeurs = chargeArrayFromFic(FILESERVEUR);
	
	for($i=0;$i<count($pServ);$i++)
	{
		$arrayResult[] = $arrayListServeurs[$pServ[$i] - 1];
	}
	
	return $arrayResult;
}

/**
* Fonction js_CreeVerif : Cration de la fonction JavaScript de verif de submit
*
* Renvoi le texte JavaScript qui Affiche le nombre de serveurs slectionns et la requte SQL
*
* @return string
*/
function js_CreeVerif()
{
	global $txtLang;
	$lgReq = MRSLGSQL;
	
	$htmlText  = "<script type=\"text/javascript\">\n";
	$htmlText .= "function verifsubmit()\n";
	$htmlText .= "{\n";
	$htmlText .= "var msg;\n";
	$htmlText .= "var lgreq;\n";
	$htmlText .= "var nbrserv = GetNbreSelectListe(document.getElementById('idlisteserveurs'));\n";
	$htmlText .= "var txtSql  = document.getElementById('txtsql').value;\n";
    $htmlText .= "if (nbrserv == 0)\n";
	$htmlText .= "{\n";
	$htmlText .= "alert(\"". $txtLang['errpasserveur'] ." \");\n";
	$htmlText .= "return false;\n";
	$htmlText .= "}\n";	
	$htmlText .= "msg = \"" . $txtLang['nbreserveurs'] ." : \";\n";
	$htmlText .= "msg = msg + (nbrserv);\n";
	$htmlText .= "msg = msg + \"\\r\\n\";\n";
	$htmlText .= "msg = msg + \"" . $txtLang['requetesql'] . " : \" + document.getElementById('txtsql').value.substring(0,$lgReq) + \"(...)\";\n";
    $htmlText .= "if (confirm(msg))\n";
	$htmlText .= "{\n";
	$htmlText .= "return true;\n";
	$htmlText .= "}\n";
	$htmlText .= "else\n";
	$htmlText .= "{\n";
	$htmlText .= "return false;\n";
	$htmlText .= "}\n";	
	$htmlText .= "}\n";	
	$htmlText .= "</script>\n";
	
	return unhtmlentities($htmlText);
}
/**
* Fonction js_CreeVerifCompBase : Cration de la fonction JavaScript de verif de submit
* pour la comparaison de bases SQL
*
* Renvoi le texte JavaScript qui Affiche le nombre de serveurs slectionns
*
* @return string
*/
function js_CreeVerifCompBase()
{
	global $txtLang;
	
	$htmlText  = "<script type=\"text/javascript\">\n";
	$htmlText .= "function verifsubmit()\n";
	$htmlText .= "{\n";
	$htmlText .= "var msg;\n";
	$htmlText .= "var nbrserv = GetNbreSelectListe(document.getElementById('idlisteserveurs'));\n";
	$htmlText .= "var nbrservref = GetNbreSelectListe(document.getElementById('idlisteserveursref'));\n";
	$htmlText .= "if (nbrserv == 0)\n";
	$htmlText .= "{\n";
	$htmlText .= "alert(\"". $txtLang['errpasserveur'] ." \");\n";
	$htmlText .= "return false;\n";
	$htmlText .= "}\n";	
	$htmlText .= "if (nbrservref == 0)\n";
	$htmlText .= "{\n";
	$htmlText .= "alert(\"". $txtLang['errserveurrefnondefini'] ." \");\n";
	$htmlText .= "return false;\n";
	$htmlText .= "}\n";	
	$htmlText .= "msg = \"" . $txtLang['nbreserveurs'] ." : \";\n";
	$htmlText .= "msg = msg + (nbrserv);\n";
    $htmlText .= "if (confirm(msg))\n";
	$htmlText .= "{\n";
	$htmlText .= "return true;\n";
	$htmlText .= "}\n";
	$htmlText .= "else\n";
	$htmlText .= "{\n";
	$htmlText .= "return false;\n";
	$htmlText .= "}\n";	
	$htmlText .= "}\n";	
	$htmlText .= "</script>\n";
	
	return unhtmlentities($htmlText);
}

/**
* Fonction logMessage : Ecrit un message dans un fichier Log
* 
*  
* @param string Le message
* @param string L'identit du programme
* @param string Un niveau 1, 2 ...
* @return booleen
*/		
function logMessage($pMessage,$pIdent,$pNiveau)
{
	$fp = @fopen(FILELOG, "a");

	if ( ! $fp)
	{
		return false;
	}
	
	$data = date(LNGDATEHMS) . $pIdent . "\t" . $pNiveau . "\t" .$pMessage."\r\n";
	fwrite($fp,$data);
	
	fclose($fp);
	return true;
}
/**
* Fonction dimLgCode : Formate un code action
* 
*  
* @param string Le code
* @return string Le code format
*/	
function dimLgCode($pCode)
{
	$lgCode = MRSLGCODE;
	
	$pCode = trim($pCode);
	$lgChaine = strlen($pCode);
	$rCode = $pCode . str_repeat(" ",($lgCode - $lgChaine));
	return $rCode;
}
/**
* Fonction getCommentairesPerso : Renvoi un commentaire perso
* 
*  
* @return string Le commentaire
*/	
function getCommentairesPerso()
{
	$fichier = FILEPERSO;
	include_once("Lib/inifile_class.php");
	
	$config = new readinifile($fichier); 
	$dataFic = $config->get_value("COMMENTAIRES","xml"); 
	
// 	if( ! is_readable($fichier))
// 	{
// 		return "";
// 	}
// 	$fp = @fopen($fichier, "r");
// 	if ( ! $fp)
// 	{
// 		$bret = logMessage(__FILE__ . " Ligne : " . __LINE__ . $txtLang['errfichierouv'] . " " . $fichier," getCommentairesPerso","1");
// 		return "";
// 	}
//$dataFic = fread($fp,filesize($fichier));
// fclose
	return trim($dataFic);
}

/**
* Fonction getXmlXslCss : Renvoi l'Url du XSL ou CSS pour fichier XML
* 
*  
* @return string Le commentaire
*/	
function getXmlXslCss()
{
	$fichier = FILEPERSO;
	include_once("Lib/inifile_class.php");
	
	$config = new readinifile($fichier); 
	$dataFic = trim($config->get_value("XML","xslcss")); 
	if (strlen($dataFic) < 4)
	{
		$dataFic="";
	}
	return trim($dataFic);
}
?>