REBOL [
	Title:		"Trivial XML Output Library for REBOL"
	File:		%xml-writer.r

	Author: 	"Andreas Bolka"
	Email:		andreas.bolka@gmx.net
	Rights: {
		Copyright (C) 2001, 2002 by Andreas Bolka
		Licensed under the Academic Free License version 1.1. 

		See: <URL:http://earl.strain.at/license/afl> or
		<URL:http://www.rosenlaw.com/afl.html>
    }

	Tabs:		4

	CVS-Date:		"$Date: 2002/11/10 00:32:11 $"
	CVS-Revision:	"$Revision: 1.5 $"
]

; TO DO
; - support for attributes
; - clean up formatting handling (setters!)
; - generally, that's no pretty piece of code, yet

xml-text-writer: make object! [
	; enums (statics)
	enum-formatting-plain: 0
	enum-formatting-indented: 1

	; the xml string
	content: make string! 1000

	; properties (public attributes)
	formatting: self/enum-formatting-plain
	indentation: 1
	indent-char: "^-"
	quote-char: "^""
	newline-char: crlf

	; private attributes
	my-indent-lvl: 0	
	my-open-elems: copy []
	my-last-type: none

	; private methods
	xml-encode: func [ str ] [
		replace/all str "<"  "&lt;"
		replace/all str ">"  "&gt;"
		replace/all str "&"  "&amp;"
		replace/all str "'"  "&apos;"
		replace/all str "^"" "&quot;"
		str 
	]

	emit-raw: func [ raw ] [ append content raw ]
	emit-string: func [ str ] [ emit-raw xml-encode str ]

	emit-newline: has [ i ] [
		if = formatting self/enum-formatting-indented [ 
			emit-raw newline-char
		]
	]
	emit-indent: has [ i ] [
		if = formatting self/enum-formatting-indented [
			i: 0
			while [ i < my-indent-lvl ] [
				;emit-raw rejoin array/initial self/indentation self/indent-char
				emit-raw self/indent-char
				i: i + 1
			]
		]
	]

	inc-indent-lvl: does [ my-indent-lvl: my-indent-lvl + 1 ]
	dec-indent-lvl: does [ my-indent-lvl: my-indent-lvl - 1 ]

	write-start-document: does [
		emit-raw {<?xml version="1.0"?>}
		
		my-last-type: "-"
	]

	write-start-element: func [ elem ] [
		insert my-open-elems elem

		switch my-last-type [
			"-"		[ emit-newline ]
			"se"	[ emit-newline inc-indent-lvl emit-indent ]
			"ee"	[ emit-newline emit-indent ]
		]
		emit-raw rejoin [ "<" elem ">" ]

		my-last-type: "se"
	]

	write-end-element: has [ elem ] [
		elem: first my-open-elems
		remove my-open-elems

		switch my-last-type [
			"ee"	[ emit-newline dec-indent-lvl emit-indent ]
		]
		emit-raw rejoin [ "</" elem ">" ] 

		my-last-type: "ee"
	]

	write-full-end-element: has [ elem ] [
		foreach elem copy my-open-elems [
			write-end-element elem
		]
	]

	write-element-string: func [ elem string ] [
		write-start-element elem
		write-string string
		write-end-element
	]

	write-element-raw: func [ elem raw ] [
		write-start-element elem
		write-raw raw
		write-end-element
	]

	write-string: func [ string ] [
		emit-string string

		my-last-type: "d"
	]

	write-raw: func [ raw ] [
		emit-raw raw
	]
]

; vim: set ts=4 sw=4 syn=rebol:
