<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
/**
* WebService SOAP d'excution de requtes SQL
*
*
* @package MyRemoteSql
* @author MyRemoteSql
*/
//
// Librairie Objets SOAP
include_once("Lib/nusoap.php");
//
include_once("mrsconf_inc.php");
$dirLang = DIRLANG;
$mrsLang = MRSLANG;
include_once("$dirLang/$mrsLang");
include_once("Lib/myremotesql_class.php");
include_once("Lib/sql_inc.php");
include_once("Lib/general_inc.php");
include_once("Lib/appgen_inc.php");
include_once("Lib/convertion_class.php");

//	Cration du serveur SOAP
$serveur = new soap_server;

// Dclaration de la fonction
$serveur->register('wsExecuteSql');
$serveur->register('wsGetVersion');

/**
* Fonction wsExecuteSql : Excution de la requte SQL
*
* Excute la requte SQL sur N serveurs
*
* @param string La requete SQL
* @param array  La liste des serveurs SQL (lib,IP,
* @param string Le type se sortie : HTML,CSV,XML,Texte
* @param string Le presentation de sortie S-SQL ou SQL-S
*
* @return array
*/
function wsExecuteSql($pTxtSql,$pServeurs,$pTypeSortie,$pPreSortie)
{
	global $txtLang;
	
	$pTxtSql = trim($pTxtSql);
	
	// Vrification de la requte : mots interdits ...
 	$bRet = verifClauseSql($pTxtSql);
	if (trim($bRet) != "")
	{
		return new soap_fault('Sql','',$bRet);
	}
	
	$arrayEntete = array();
	$arrayResultat = array();
	$arrayResultatTot = array();
	$arrayResultatConvert = array();
	
	// Suppression des antislach
	$txtsql = stripslashes($txtsql);
	
	// Dfinition de l'entete
	$arrayEntete[] = dimLgCode("H") . $txtLang['debuttraitement'] . " " . date(LNGDATEHMS);
	$arrayEntete[] = dimLgCode("H") . $txtLang['reqsqlest'];
	$arrayEntete[] = dimLgCode("H") . $pTxtSql;

	// Cration d'une instance de l'objet
	$remoteSql = new myRemoteSql();
	
	// Dfinition des attributs
	$remoteSql->typeDatabase = "mysql";
	$remoteSql->texteSql = $pTxtSql;
		
	// Excution du moteur de requtes 
	$arrayResultat = $remoteSql->executeSql($pServeurs,$pTxtSql,$pPreSortie);
	
	// Merge Entete + Data
	$arrayResultatTot = array_merge($arrayEntete,$arrayResultat);
	
	// Cration d'une instance de l'objet de Convertion du rsultat
	$convertion = new convertion();
	
	// Dfinition des attributs
	$convertion->typeSortie = $pTypeSortie;
	$convertion->preSortie = $pPreSortie;
	
	// Convertion du rsultat
	$arrayResultatConvert = $convertion->convertResult($arrayResultatTot);
		
	// Renvoi du rsultat
	return $arrayResultatConvert;
}

/**
* Fonction wsGetVersion : Renvoi le No de Version
*
* Renvoi le No de Version
*
*
* @return String
*/
function wsGetVersion()
{
	$numVersion = MYREMOTESQL_VERSION;
	return $numVersion;
}

// Renvoi du rsultat
$serveur->service($HTTP_RAW_POST_DATA);
?>