Rebol 
[
title: "Exemple de client Xml-RPC  adapter"
auteur: "myRemoteSql"
commentaires: "Utilise Rebol + librairies XML-RPC"
]

; Includes des librairies XML-RPC
do %Lib/xml-object.r
do %Lib/xml-parse.r
do %Lib/xmlrpc-client.r
do %Lib/xmlrpc-marshaler.r
do %Lib/xml-writer.r
;

; Dfinition le la Requte SQL
txtSql: "show databases"

; Dfinition du type de Sortie
typeSortie: "XML"

; Dfinition de la prsentation de Sortie
preSortie: "S-SQL"

; Dfinition de l'Url du webService,  modififier
url: make url! http://127.0.0.1/myremotesql/ws_mrsxmlrpc.php

; Dfinition de la liste des serveurs : peut-tre rcupre d'un fichier, d'une table ...
listServeurs: make hash! ["Serveur 1" "1;Serveur 1;localhost;3306;test;root;;" "Serveur 2" "2;Serveur2222;localhost;3306;test;root;;"] 

; Connexion au Webservice
remote: make xmlrpc-client []
remote/set-server url

; Mode Debug : mettre  true
;remote/set-debug true

; Rcup de la liste des mthodes du WebServices
print remote/exec [system.listMethods]

; Rcup du No de version
numVersion: remote/exec [mrs.wsGetVersion]
print ["le No de version est : " numVersion]

; Appel de la fonction distante
resultat: remote/exec [mrs.wsExecuteSql txtSql listServeurs typeSortie preSortie]

; Affichage du rsultat brut, le rsultat est un Hash!
probe resultat

; Exploitation du rsultat ...  personnaliser ... Mise  jour IHM, SGBD, Fichier, Mail ...

; Rcup de la longueur du Hash!
nbr: length? resultat
nbr: nbr / 2
nbr: nbr - 1
; boucle sur les enregistrements + criture fichier
for ind 0 nbr 1 
[
	data1: select resultat to-string(ind)
	write/append %result.xml data1
]

; Fin programme : arrt + Quit
Input
quit