<html>
<head>
<title>Client Webservice MyRemoteSql SOAP</title>
</head>
<body>
<?php
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
/**
* Exemple de client PHP SOAP pour accs au Web Service
*
* A personnaliser
*
* @package MyRemoteSql
* @author MyRemoteSql
*/
// Librairie nusoap
include('Lib/nusoap.php'); 

// dfinition de la liste des serveurs  traiter
$listServeurs = array();
$listServeurs[] = "1;Serveur 1;localhost;3306;test;root;;";
$listServeurs[] = "2;Serveur 2;localhost;3306;test;root;;";

// dfinition de l'Url du Webservice
$urlWebService = "http://127.0.0.1/myremotesql/ws_mrssoap.php";

// dfinition de la requte SQL  excuter (Select, Insert ...)
$txtSql = "SHOW databases";

// dfinition du type de sortie
$typeSortie = "TEXTE";

// dfinition de la prsentation de sortie
$preSortie = "S-SQL";

// dfinition des parametres du Webservice (Requete SQL, Liste de serveurs, type de sortie, prsentation sortie)
$param = array("pTxtSql" => $txtSql, "pServeurs" => $listServeurs, "pTypeSortie" => $typeSortie, "pPreSortie" => $preSortie);

// Cration du client SOAP
$client = new soapclient($urlWebService);

// Appel de la fonction distante
$result = $client->call("wsExecuteSql", $param);

// Erreur ?
if ($client->fault)
{
	print("Erreur " . $result['faultcode'] . " " . $result['faultstring']);
}
else
{
	// affichage BRUT du rsultat
	print("<pre>");
	print_r($result);
	print("</pre>");
	
	// Exploitation du rsultat ...  personnaliser ... Mise  jour IHM, SGBD, Fichier, Mail ...
	//
	$fp = @fopen("result.txt", "w");
	if ( ! $fp)
	{
		die("Erreur ouverture fichier");
	}
	//
	for ( $i = 0;$i < count($result);$i++)
	{
		fwrite($fp,$result[$i]."\n");
	}
	fclose($fp);
}
// Rcupration du No de Version
$param2 = array();
$result = $client->call('wsGetVersion', $param2);
// Erreur ?
if ($client->fault)
{
	print("Erreur " . $result['faultcode'] . " " . $result['faultstring']);
}
else
{
	print("No de Version : $result");
}
?>
</body>
</html>