REBOL [
	Title:		"rebXR - XML-RPC library for REBOL, client component"
	File:		%xmlrpc-client.r

	Author:		"Andreas Bolka"
	Email:		andreas.bolka@gmx.net
	Rights: {
		Copyright (C) 2001, 2002 by Andreas Bolka
		Licensed under the Academic Free License version 1.1. 

		See: <URL:http://earl.strain.at/license/afl> or
		<URL:http://www.rosenlaw.com/afl.html>
	}

	Tabs:		4

	CVS-Date:		"$Date: 2002/11/11 10:12:54 $"
	CVS-Revision:	"$Revision: 1.9 $"
]

xmlrpc-client: make object! [
	nlchr: crlf
	server-url: none
	server: none
	proxy: none
	debug: func [ value ] [ value ]

	set-server: func [ url [url!] ] [
		server: decode-url url
		server-url: url
		if none? server/path	[ server/path: "" ]
		if none? server/target	[ server/target: "" ]
		if none? server/port-id	[ server/port-id: 80 ]
		return 
	]

	set-proxy: func [ url [url! none!] ] [
		either none? url [ proxy: none ] [ proxy: decode-url url ]
	]

	set-debug: func [ status [logic! none!] ] [ 
		debug: either to-logic status [
			func [ value ] [ probe value ]
		] [
			func [ value ] [ value ]
		]
	]
	
	exec: function [ method-block [block!] ] [
		post-string host-string req xml-req url con res data errstr
	] [
		post-string: either proxy [ server-url ] [ rejoin [ "/" server/path server/target ] ]
		host-string: either proxy [ proxy/host ] [ server/host ]

		;; - request
		req: copy ""

		xml-req: xmlrpc-marshaler/marshal-req method-block
		append xml-req nlchr

		append req rejoin [ "POST " post-string  " HTTP/1.0" nlchr ]
		append req rejoin [ "Host: " host-string nlchr ]
		append req rejoin [ "User-Agent: rebXR 1.2.2 (http://earl.strain.at/space/rebXR)" nlchr ]
		append req rejoin [ "Content-Type: text/xml" nlchr ]
		append req rejoin [ "Content-Length: " (length? xml-req) nlchr ]
		append req nlchr
		append req xml-req

		url: any [ proxy server ]
		; open/binary to preserve line-seperators
		con: open/binary to-url rejoin [ "tcp://" url/host ":" url/port-id ]
			
		debug "; === Request ==="
		insert con debug req

		;; - response
		res: copy ""
		while [ data: copy con ] [ append res to-string data ]
		close con

		debug "; === Response ==="
		debug res
		html-code: second parse res " "
		res: find res "<?xml"
		if not found? res [
			make error! "Response does not contain a proper xml prolog (<?xml ... ?>). Use /debug to debug."
		]
		
		either = "200" html-code [
			xmlrpc-marshaler/unmarshal-resp res
		] [
			errstr: rejoin [ "HTML " html-code " response (200 expected). Use /debug to debug." ]
			make error! errstr
		]
	]

	static-exec: function [ srv-url method-block /proxy pxy-url /debug ] [
		o
	] [
		o: make xmlrpc-client []
		o/set-server srv-url
		o/set-proxy pxy-url ; is none if called without /proxy refinement
		o/set-debug debug	; same
		o/exec method-block
	]
]

set 'xmlrpc-exec get in xmlrpc-client 'static-exec

; vim: set ts=4:
